/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.admin;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.ParentPackage;

@ParentPackage(value="admin")
@InterceptorRefs(value={@InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="defaultStack")})
public class ListProjectsAction
extends CoserAction {
    private static final long serialVersionUID = 6024588562104111883L;
    protected Map<String, String> facades;
    protected Map<String, List<String>> zonesByFacades;
    protected Map<String, String> indicatorsResults;
    protected Map<String, String> mapsResults;

    public Map<String, String> getFacades() {
        return this.facades;
    }

    public Map<String, List<String>> getZonesByFacades() {
        return this.zonesByFacades;
    }

    public Map<String, String> getIndicatorsResults() {
        return this.indicatorsResults;
    }

    public Map<String, String> getMapsResults() {
        return this.mapsResults;
    }

    public String getZoneDisplayName(String zoneId) {
        WebService webService = ServiceFactory.getWebService();
        String zoneDisplayName = null;
        try {
            zoneDisplayName = webService.getZoneFullName(zoneId);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone name", (Throwable)ex);
        }
        return zoneDisplayName;
    }

    public String execute() {
        WebService webService = ServiceFactory.getWebService();
        try {
            this.facades = webService.getFacades();
            this.zonesByFacades = webService.getZoneByFacade();
            this.indicatorsResults = webService.getIndicatorsResultsPerZone();
            this.mapsResults = webService.getMapsResultsPerZone();
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get data from web service", (Throwable)ex);
        }
        return "success";
    }
}

