/*
 * #%L
 * $Id: GraphAction.java 818 2011-05-06 08:04:19Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.6/coser-web/src/main/java/fr/ifremer/coser/web/actions/com/GraphAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.com;

import java.util.Locale;
import java.util.Map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Affiche le graphique demandé.
 * 
 * Parametre : zone, species, indicator.
 *  
 * @author chatellier
 * @version $Revision: 818 $
 * 
 * Last update : $Date: 2011-05-06 10:04:19 +0200 (Fri, 06 May 2011) $
 * By : $Author: chatellier $
 */
public class GraphAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    protected String facade;

    protected String zone;

    protected String indicator;

    /** La liste des nom de liste du fichier de communauté pour l'indicateur. */
    protected Map<String, String> lists;

    /** La liste actuellement selectionnée (cas null géré). */
    protected String list;

    public String getFacade() {
        return facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIndicator() {
        return indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public Map<String, String> getLists() {
        return lists;
    }

    public String getList() {
        return list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", ex);
        }
        return displayName;
    }
    
    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getZoneForFacade(facade, false, false).get(zone);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", ex);
        }
        return displayName;
    }
    
    public String getIndicatorDisplayName() {
        
        Locale locale = getLocale();
        String localeCode = locale.getLanguage();

        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getIndicators(zone, null, localeCode).get(indicator);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }

    @Override
    public String execute() {

        Locale locale = getLocale();
        String localeCode = locale.getLanguage();

        WebService webService = ServiceFactory.getWebService();
        try {
            lists = webService.getIndicatorLists(zone, indicator, localeCode);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get indicator's list names", ex);
        }
        return SUCCESS;
    }
}
