/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

public class MapAction
extends CoserAction {
    private static final long serialVersionUID = 1663244944108703571L;
    protected String facade;
    protected String zone;
    protected String species;

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getFacade() {
        return this.facade;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getZoneForFacade(this.facade, false, true).get(this.zone);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getSpeciesDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getSpecies(this.zone, true).get(this.species);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }
}

