/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import com.bbn.openmap.MapBean;
import com.google.common.base.Preconditions;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserClassLoader;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserExceptionHandler;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.DefaultCoserApplicationContext;
import fr.ifremer.coser.services.ClientResultService;
import fr.ifremer.coser.services.CommandService;
import fr.ifremer.coser.services.ControlService;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.services.PublicationService;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.UIManager;
import jaxx.runtime.swing.session.SwingSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;

public class CoserUIApplicationContext
extends DefaultCoserApplicationContext {
    private static final Log log = LogFactory.getLog(CoserUIApplicationContext.class);
    protected static CoserUIApplicationContext context;
    protected SwingSession session;
    protected CommandService commandService;
    protected ProjectService projectService;
    protected ControlService controlService;
    protected PublicationService publicationService;
    protected ClientResultService clientResultService;

    public static CoserUIApplicationContext get() {
        Preconditions.checkState((context != null ? 1 : 0) != 0, (Object)"Application was not initialized!");
        return context;
    }

    public static CoserUIApplicationContext init() {
        CoserConfig config;
        block8: {
            Preconditions.checkState((boolean)EventQueue.isDispatchThread(), (Object)"Must init application context from Swing EDT Thread");
            context = new CoserUIApplicationContext();
            config = context.getConfig();
            try {
                I18n.init((I18nInitializer)new DefaultI18nInitializer("coser-i18n"), (Locale)config.getLocale());
            }
            catch (RuntimeException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Could not load coser i18n bundle", (Throwable)ex);
                }
                I18n.init((I18nInitializer)new ClassPathI18nInitializer(), (Locale)config.getLocale());
            }
            MapBean.suppressCopyright = true;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            CoserClassLoader coserClassLoader = new CoserClassLoader(currentClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)coserClassLoader);
            coserClassLoader.setValidatorsDirectory(config.getValidatorsDirectory());
            try {
                String lafClassName = config.getLookAndFeel();
                for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                    if (!laf.getClassName().equalsIgnoreCase(lafClassName)) continue;
                    UIManager.setLookAndFeel(laf.getClassName());
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"Can't init look and feel", (Throwable)ex);
            }
        }
        config.updateSwingFont();
        File coserConfigDirectory = new File(config.getUserConfigDirectory(), "coser");
        try {
            FileUtils.forceMkdir((File)coserConfigDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not create user data directory", (Throwable)e);
        }
        File mainFrameFile = new File(coserConfigDirectory, "session.xml");
        CoserUIApplicationContext.context.session = SwingSession.newSession((File)mainFrameFile, (boolean)true);
        Thread.setDefaultUncaughtExceptionHandler(new CoserExceptionHandler());
        System.setProperty("sun.awt.exception.handler", CoserExceptionHandler.class.getName());
        return context;
    }

    public static void close() {
        context = null;
    }

    public SwingSession getSession() {
        return this.session;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public ProjectService getProjectService() {
        return this.projectService;
    }

    public ControlService getControlService() {
        return this.controlService;
    }

    public PublicationService getPublicationService() {
        return this.publicationService;
    }

    public ClientResultService getClientResultService() {
        return this.clientResultService;
    }

    protected CoserUIApplicationContext() {
        super((CoserBusinessConfig)new CoserConfig());
        this.projectService = new ProjectService(this.config);
        this.commandService = new CommandService(this.config);
        this.controlService = new ControlService(this.config);
        this.publicationService = new PublicationService(this.config);
        this.clientResultService = new ClientResultService(this.config);
    }

    public CoserConfig getConfig() {
        return (CoserConfig)this.config;
    }
}

