package fr.ifremer.coser.ui.option;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.nuiton.jaxx.widgets.extra.editor.Editor;
import static org.nuiton.i18n.I18n.t;

public class ValidatorDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8TORh2s6QlaaGl0RYQXalAD4gPZ7urPRXx1VJBFApqK1QRDjgZN3VxbK/taYbLan/C/gS4c0HitqcVB84cuKz2L6wQB66I154006HTMCI5zGT8Ps/jx+/Yz7z8HxWNRmd3SBRhHQrLOhTXbm5u3m/u0JZdpqalmbJSo/g3UkCFBhoP+uPGovONuqNXe/TqkuwoKajYx16so7Kxzzg125Rai35KM1rGVNf75cVIhXpPtW8qS/X5xw+Fv4I/XxQQihS4OwFLmfsWK1nJkToqsMCiaZhpl1Q5EW2woZlog99jbmyJE2NWSYf+jv5AY3U0qogGMYvO5V+y1/D8SFlUmq8tM8Jl+2eLLm5pzLY07VCNW9LANWRYKsukwA8JZwEBnRitlJcYtWhsm4iAU23RhQH0+/52J4Ym5IqQS1IxGmzIZWae1skzJzQrdRvvwDt9aqXCOxF3w7i26cuOWUpmn98gTU7B/KlUn00XuoZ9zSEn+4Sj87U6aVIOjGnX0agHjUcdaPoAdsE9n8yu/ZJROzZfW29pyfkDIpy1k6mJklKaVdnda7HZ0JTekwHlFuE87yQhJK09npaz6ETKhRtzyNk+YapHAOXbAQOeRZfcixAhPAjs29tlQZtag2lkNcHUw3CMPtAet8KDbfajaSxswVuhhTkAXEmB42EHu9BHT7Y0JZau0m5SvZKGlA3ZpYdWJ6BN1B5e79tZ2F/U6Exqg0FE4CQikjM80kBFHcIw7MjGwVRZg1KcJ6e+yhMn6KufZyrv//7v9cr+EPkxE7ovA+FwKy0VnB7mpp6MEyS0jFfvEbXYQCUDq27FATmbYWy9VwZzMJ/fK9jR8R1itkGiOPbvP29mnrz7ARVWUJlLEqwQh7+LSnZbQxckDyJ1/YZ3NNE9Ctcp582iomUWGo6mrzLBmaBzxEKmNUNLr0XQh9mMPvTNNEtvP1XWX93Y68UIeDt9KDzpR/ERGo1n85HaS8vMCB1XhoaBTFIxKydH3L2seqdr0V+vZy22vCWFveL5DnMrCt1tyVt3/257pZkcSkcsHLKhNNzw6gCF00MrnMmxjokW5XyNioBql+3Hr0LEkLkmEwEc8WvZuudz6BY7Lu9c+fH3i4xrKe1DZlhz4PvKIzUFR6Br1kAv/sqZofS+1fnLORyNUeG+f8EAmerQRvIpDNrIC0N7yKcwyMOvQ3sYXuE3UPgC7iyaQv8KAAA=";
    private static final Log log = LogFactory.getLog(ValidatorDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton createNewButton;
    protected JButton deleteButton;
    protected OptionHandler handler;
    protected JXLayer noCopiedToDiskLayer;
    protected JButton saveButton;
    protected Editor validationEditor;
    protected JTree validatorsTree;
    protected ValidatorsTreeModel validatorsTreeModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private ValidatorDialog $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidatorDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog() {
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidatorDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidatorDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().restoreDefaults(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__createNewButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createNew(this);
    }

    public void doActionPerformed__on__deleteButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteValidator(this);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveValidator(this);
    }

    public void doValueChanged__on__validatorsTree(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectValidator(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCreateNewButton() {
        return createNewButton;
    }

    public JButton getDeleteButton() {
        return deleteButton;
    }

    public OptionHandler getHandler() {
        return handler;
    }

    public JXLayer getNoCopiedToDiskLayer() {
        return noCopiedToDiskLayer;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public Editor getValidationEditor() {
        return validationEditor;
    }

    public JTree getValidatorsTree() {
        return validatorsTree;
    }

    public ValidatorsTreeModel getValidatorsTreeModel() {
        return validatorsTreeModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(OptionHandler handler) {
        OptionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNoCopiedToDiskLayer() {
        if (!allComponentsCreated) {
            return;
        }
        noCopiedToDiskLayer.setView($Table0);
    }

    protected void createCreateNewButton() {
        $objectMap.put("createNewButton", createNewButton = new JButton());
        
        createNewButton.setName("createNewButton");
        createNewButton.setEnabled(false);
        createNewButton.setText(t("coser.ui.validators.createNew"));
        createNewButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createNewButton"));
    }

    protected void createDeleteButton() {
        $objectMap.put("deleteButton", deleteButton = new JButton());
        
        deleteButton.setName("deleteButton");
        deleteButton.setEnabled(false);
        deleteButton.setText(t("coser.ui.validators.deleteValidator"));
        deleteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createNoCopiedToDiskLayer() {
        $objectMap.put("noCopiedToDiskLayer", noCopiedToDiskLayer = new JXLayer());
        
        noCopiedToDiskLayer.setName("noCopiedToDiskLayer");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setEnabled(false);
        saveButton.setText(t("coser.ui.validators.saveValidator"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createValidationEditor() {
        $objectMap.put("validationEditor", validationEditor = new Editor());
        
        validationEditor.setName("validationEditor");
    }

    protected void createValidatorsTree() {
        $objectMap.put("validatorsTree", validatorsTree = new JTree());
        
        validatorsTree.setName("validatorsTree");
        validatorsTree.setRootVisible(false);
        validatorsTree.setShowsRootHandles(true);
        validatorsTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__validatorsTree"));
    }

    protected void createValidatorsTreeModel() {
        $objectMap.put("validatorsTreeModel", validatorsTreeModel = new ValidatorsTreeModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add(noCopiedToDiskLayer);
        addChildrenToNoCopiedToDiskLayer();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(validationEditor, new GridBagConstraints(1, 2, 1, 1, 2.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(validatorsTree);
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add(createNewButton);
        $JPanel0.add(saveButton);
        $JPanel0.add(deleteButton);
        $JPanel0.add($JButton1);
        
        // apply 2 property setters
        validatorsTree.setCellRenderer(new ValidatorsTreeRenderer());
        validatorsTree.setModel(validatorsTreeModel);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createHandler();
        createNoCopiedToDiskLayer();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel0.setText(t("coser.ui.validators.description"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("coser.ui.validators.validators"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("coser.ui.validators.content"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createValidatorsTreeModel();
        createValidatorsTree();
        createValidationEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("coser.ui.validators.restoredefaults"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createCreateNewButton();
        createSaveButton();
        createDeleteButton();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("coser.ui.validators.close"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JDialog0
        setName("$JDialog0");
        setTitle(t("coser.ui.validators.title"));
        
        $completeSetup();
    }

}