package fr.ifremer.coser.ui.result;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.ui.selection.SelectionHandler;
import fr.ifremer.coser.ui.selection.model.FileListModel;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class SelectionAddResultDialog extends JDialog implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_RESULT_ZONE_COMBO_MODEL = "resultZoneComboModel";
    public static final String PROPERTY_RSUFI_RESULT = "rsufiResult";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESULT_NAME_FIELD_TEXT = "resultNameField.text";
    public static final String BINDING_RESULT_ZONE_COMBO_MODEL = "resultZoneCombo.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXz28bRRSemDqJk7YJSeu2IhUpdcWhsG6TFColSpvGMo3l0BBXIaol1LF3Yk+y3tnOzCbbC+qFO3cucOeCxI0T4sCZAxfEv4AQB66IN7vr3aw9dtxuDnbyfnzvm/fezHv5/i+UFRzdOMSeZ3DXlrRDjMrG/v6TxiFpyhIRTU4dyTgKfsYyKFNH02YkFxLdrFeVezF0L26yjsNsYp/yXq2iKSFfWkS0CZESXU96NIUo1iL1que4vIsakdKhfvvP35mvzVffZRDyHGD3Phxl8Syv+CTnqihDTYnmINIxLlrYbgENTu0W8L2gZJsWFuJT3CEv0JdooorGHcwBTKL3Rj+yj+H7e45EuUKlRLHFWnckWj7gBj3gpEO40WQCPl1qcCJcSxo1YkH+KbM3THPXFwVujuNjjUs0UXiKGxYBnKuJI4sTOIDh65RlLnZoY9u0CJfI0AUW3Yhx7MeBQxxzmgv3gAZ8JLrRB9Mg2DZ2a5FN7DlLOIdu8WltM5NYEq0laB9ji5oYEhceoKY+97rCbSIEbpHYPUa+FHmeCizR7ddAj8EmC5UqbhALsjqnGsAL7QOpMjof2c4EpVLtUabEgkbKJ1yeEk/6iqTbVKHEmm4HmgWCXDvtIcHB6Cr7Od1Vf19Pgs0FHHZVWfYIF1A0pVkcFNLHuNmPvTQYe5MTrJqhhCWRaJHxlnEI9/9IMifg7RmVfaXcoc0jwpMYXfxlDf6lAP8ZXBy4Pw0WtsUHQ25FZPuIeT1tMNODJtHlRDW6bnp+Kxp+eSIkeG3ZZplaJFHNgfld6skvXPdHrpTMhlrPJ/gEYj2bewPY7DDntdgsD2Ljt8EDffCPdME72BElyuFZYPzlaMFXBgVfGhL8Y03wK47bsKi6+cHd3myT5hFUsq/CoVyPfF+DfKFQqTU5s6wdbKuH9EoCL1b1JIPJNuHQ8VhVokqFDDv37vBntaOsjIRPnJ23+0BBlnyBQKaMP++dAH4xLyY5RslejpL9vF+5olHOCnwcJjpu0a4NR+8knlUY3EY8uOPJOlZHWe6CGIZTvX/W74IqmPJXe6a8AvS1/+Xnf//pzx/L3dGeh9iXtaanNhMYuQ5nDow4qkLPBHPdldQqbmNntY5yQTX8tWVBQ6wWqoEcxPPzbyh34zEWbYDITvzx8y/557+9hTJlNGUxbJaxst9COdmGB6jNLNNzHjz0GZ0/mYTPWcVNoixUH0OPzK1R26I2WcQSNo2GK8m6B3lY0OQhItPI/frvfO2Hh91cjAG3awPN43xkn6HxIJq/6IQ7jHaxmXYEcU0W7yq67WVMfU85YdN2/M8X2sNKKoPtQ3qu+nJ91uq3k5FBzqlxOARj4UwMJX4l0cU1GPJ4sUFtEy7Suh7t3dHQhvC5lRrh9ihZgbP4mf1Kj/FhahZ3Rimw/5YNoXFvBJBJWKVNwoOV4Y1xzjrO/dQI66kRNlIjfJIaYSs1wpPUCJ+lRtgbCeGbIR31RWoOzdQIJDUC/B/o/A98UNIKvA8AAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    private static final Log log = LogFactory.getLog(SelectionAddResultDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SwingValidatorMessageTableModel errorsTableModel;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "estComIndPath",  editorName = "estComIndFileTextField")
    protected JTextField estComIndFileTextField;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "estPopIndPath",  editorName = "estPopIndFileTextField")
    protected JTextField estPopIndFileTextField;
    protected SelectionHandler handler;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "mapsPath",  editorName = "mapsDirectoryTextField")
    protected JTextField mapsDirectoryTextField;
    protected JList otherDataFileList;
    protected FileListModel otherDataFileListModel;
    protected JCheckBox publiableResultCheckBox;
    protected JXDatePicker resultCreationDate;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "name",  editorName = "resultNameField")
    protected JTextField resultNameField;
    @ValidatorField( validatorId = "validatorRSufiResult",  propertyName = "rsufiVersion",  editorName = "resultRsufiVersion")
    protected JTextField resultRsufiVersion;
    protected JComboBox resultZoneCombo;
    protected ZoneComboBoxModel resultZoneComboModel;
    protected RSufiResult rsufiResult;
    protected JButton saveResultButton;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorRSufiResult")
    protected SwingValidator<RSufiResult> validatorRSufiResult;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private Document $Document2;
    private Document $Document3;
    private Document $Document4;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private SelectionAddResultDialog $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionAddResultDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog() {
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionAddResultDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionAddResultDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectResultFile(this, estComIndFileTextField);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectResultFile(this, estPopIndFileTextField);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectMapsDirectory(this, mapsDirectoryTextField);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectResultFileOrDirectory(this, otherDataFileList);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__publiableResultCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setPubliableResult(publiableResultCheckBox.isSelected());
    }

    public void doActionPerformed__on__resultCreationDate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setCreationDate(resultCreationDate.getDate());
    }

    public void doActionPerformed__on__resultZoneCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setZone((String)resultZoneCombo.getSelectedItem());
    }

    public void doActionPerformed__on__saveResultButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().performAddResult(this);
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setName(resultNameField.getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setRsufiVersion(resultRsufiVersion.getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setEstComIndPath(estComIndFileTextField.getText());
    }

    public void doInsertUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setEstPopIndPath(estPopIndFileTextField.getText());
    }

    public void doInsertUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setMapsPath(mapsDirectoryTextField.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setName(resultNameField.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setRsufiVersion(resultRsufiVersion.getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setEstComIndPath(estComIndFileTextField.getText());
    }

    public void doRemoveUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setEstPopIndPath(estPopIndFileTextField.getText());
    }

    public void doRemoveUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setMapsPath(mapsDirectoryTextField.getText());
    }

    public void doTableChanged__on__errorsTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveResultButton.setEnabled(errorsTableModel.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public JTextField getEstComIndFileTextField() {
        return estComIndFileTextField;
    }

    public JTextField getEstPopIndFileTextField() {
        return estPopIndFileTextField;
    }

    public SelectionHandler getHandler() {
        return handler;
    }

    public JTextField getMapsDirectoryTextField() {
        return mapsDirectoryTextField;
    }

    public JList getOtherDataFileList() {
        return otherDataFileList;
    }

    public FileListModel getOtherDataFileListModel() {
        return otherDataFileListModel;
    }

    public JCheckBox getPubliableResultCheckBox() {
        return publiableResultCheckBox;
    }

    public JXDatePicker getResultCreationDate() {
        return resultCreationDate;
    }

    public JTextField getResultNameField() {
        return resultNameField;
    }

    public JTextField getResultRsufiVersion() {
        return resultRsufiVersion;
    }

    public JComboBox getResultZoneCombo() {
        return resultZoneCombo;
    }

    public ZoneComboBoxModel getResultZoneComboModel() {
        return resultZoneComboModel;
    }

    public RSufiResult getRsufiResult() {
        return rsufiResult;
    }

    public JButton getSaveResultButton() {
        return saveResultButton;
    }

    public SwingValidator<RSufiResult> getValidatorRSufiResult() {
        return validatorRSufiResult;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void set$Document3(Document $Document3) {
        Document oldValue = this.$Document3;
        this.$Document3 = $Document3;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, $Document3);
    }

    public void set$Document4(Document $Document4) {
        Document oldValue = this.$Document4;
        this.$Document4 = $Document4;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, $Document4);
    }

    public void setHandler(SelectionHandler handler) {
        SelectionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setResultZoneComboModel(ZoneComboBoxModel resultZoneComboModel) {
        ZoneComboBoxModel oldValue = this.resultZoneComboModel;
        this.resultZoneComboModel = resultZoneComboModel;
        firePropertyChange(PROPERTY_RESULT_ZONE_COMBO_MODEL, oldValue, resultZoneComboModel);
    }

    public void setRsufiResult(RSufiResult rsufiResult) {
        RSufiResult oldValue = this.rsufiResult;
        this.rsufiResult = rsufiResult;
        firePropertyChange(PROPERTY_RSUFI_RESULT, oldValue, rsufiResult);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected Document get$Document3() {
        return $Document3;
    }

    protected Document get$Document4() {
        return $Document4;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToValidatorRSufiResult() {
        if (!allComponentsCreated) {
            return;
        }
        validatorRSufiResult.setErrorTableModel(errorsTableModel);
        validatorRSufiResult.setUiClass(ImageValidationUI.class);
        validatorRSufiResult.setBean(rsufiResult);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createEstComIndFileTextField() {
        $objectMap.put("estComIndFileTextField", estComIndFileTextField = new JTextField());
        
        estComIndFileTextField.setName("estComIndFileTextField");
        estComIndFileTextField.setColumns(15);
    }

    protected void createEstPopIndFileTextField() {
        $objectMap.put("estPopIndFileTextField", estPopIndFileTextField = new JTextField());
        
        estPopIndFileTextField.setName("estPopIndFileTextField");
        estPopIndFileTextField.setColumns(15);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createMapsDirectoryTextField() {
        $objectMap.put("mapsDirectoryTextField", mapsDirectoryTextField = new JTextField());
        
        mapsDirectoryTextField.setName("mapsDirectoryTextField");
        mapsDirectoryTextField.setColumns(15);
    }

    protected void createOtherDataFileList() {
        $objectMap.put("otherDataFileList", otherDataFileList = new JList());
        
        otherDataFileList.setName("otherDataFileList");
    }

    protected void createOtherDataFileListModel() {
        $objectMap.put("otherDataFileListModel", otherDataFileListModel = new FileListModel());
    }

    protected void createPubliableResultCheckBox() {
        $objectMap.put("publiableResultCheckBox", publiableResultCheckBox = new JCheckBox());
        
        publiableResultCheckBox.setName("publiableResultCheckBox");
        publiableResultCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__publiableResultCheckBox"));
    }

    protected void createResultCreationDate() {
        $objectMap.put("resultCreationDate", resultCreationDate = new JXDatePicker());
        
        resultCreationDate.setName("resultCreationDate");
        resultCreationDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resultCreationDate"));
    }

    protected void createResultNameField() {
        $objectMap.put("resultNameField", resultNameField = new JTextField());
        
        resultNameField.setName("resultNameField");
        resultNameField.setColumns(15);
    }

    protected void createResultRsufiVersion() {
        $objectMap.put("resultRsufiVersion", resultRsufiVersion = new JTextField());
        
        resultRsufiVersion.setName("resultRsufiVersion");
        resultRsufiVersion.setColumns(15);
    }

    protected void createResultZoneCombo() {
        $objectMap.put("resultZoneCombo", resultZoneCombo = new JComboBox());
        
        resultZoneCombo.setName("resultZoneCombo");
        resultZoneCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resultZoneCombo"));
    }

    protected void createResultZoneComboModel() {
        $objectMap.put("resultZoneComboModel", resultZoneComboModel = ZoneComboBoxModel.newModel(this));
    }

    protected void createRsufiResult() {
        $objectMap.put("rsufiResult", rsufiResult = null);
    }

    protected void createSaveResultButton() {
        $objectMap.put("saveResultButton", saveResultButton = new JButton());
        
        saveResultButton.setName("saveResultButton");
        saveResultButton.setText(t("coser.ui.result.validNewResult"));
        saveResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveResultButton"));
    }

    protected void createValidatorRSufiResult() {
        $objectMap.put("validatorRSufiResult", validatorRSufiResult = SwingValidator.newValidator(RSufiResult.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(resultNameField), new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(resultRsufiVersion), new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultCreationDate, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultZoneCombo, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(estComIndFileTextField), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(estPopIndFileTextField), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(mapsDirectoryTextField), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton2, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(publiableResultCheckBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel8, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 9, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 10, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToValidatorRSufiResult();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(otherDataFileList);
        // inline complete setup of $Table1
        $Table1.add($JButton3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton4, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(saveResultButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        resultCreationDate.setDate(new java.util.Date());
        resultZoneCombo.setRenderer(new ZoneComboBoxRenderer());
        otherDataFileList.setModel(otherDataFileListModel);
        // late initializer
        $JDialog0.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createHandler();
        createRsufiResult();
        createErrorsTableModel();
        createValidatorRSufiResult();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("coser.ui.result.resultName"));
        createResultNameField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = resultNameField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("coser.ui.result.rsufiVersion"));
        createResultRsufiVersion();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = resultRsufiVersion.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("coser.ui.result.creationDate"));
        createResultCreationDate();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("coser.ui.result.zone"));
        createResultZoneComboModel();
        createResultZoneCombo();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("coser.ui.result.estComIndFile"));
        createEstComIndFileTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = estComIndFileTextField.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("coser.ui.common.selectFile"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("coser.ui.result.estPopIndFile"));
        createEstPopIndFileTextField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = estPopIndFileTextField.getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("coser.ui.common.selectFile"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t("coser.ui.result.mapsDirectory"));
        createMapsDirectoryTextField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = mapsDirectoryTextField.getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("coser.ui.common.selectFile"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("coser.ui.result.publiableResult"));
        createPubliableResultCheckBox();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("coser.ui.result.otherDataFile"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createOtherDataFileListModel();
        createOtherDataFileList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(t("coser.ui.result.addOtherDataFile"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(t("coser.ui.result.cancel"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        createSaveResultButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(t("coser.ui.result.newResult"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_NAME_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    SwingUtil.setText(resultNameField, getRsufiResult().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESULT_ZONE_COMBO_MODEL, true ,"resultZoneComboModel") {
        
            @Override
            public void processDataBinding() {
                resultZoneCombo.setModel(getResultZoneComboModel());
            }
        });
    }

}