/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.project;

import fr.ifremer.coser.services.ProjectService;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import java.util.List;

/**
 * Validation categories list model.
 *
 * @author chatellier
 */
public class ProjectNamesListModel extends AbstractListModel implements ComboBoxModel {


    private static final long serialVersionUID = 6700971928409164642L;

    protected ProjectOpenView view;

    protected List<String> projects;

    protected Object selectedItem;

    public ProjectNamesListModel(ProjectOpenView view) {
        super();
        this.view = view;
    }

    public List<String> getProjects() {
        if (projects == null) {
            ProjectService service = view.getContextValue(ProjectService.class);
            projects = service.getProjectNames();
        }
        return projects;
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        return getProjects().size();
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return getProjects().get(index);
    }

    /*
     * @see javax.swing.ComboBoxModel#setSelectedItem(java.lang.Object)
     */
    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;

    }

    /*
     * @see javax.swing.ComboBoxModel#getSelectedItem()
     */
    @Override
    public Object getSelectedItem() {
        return selectedItem;
    }
}
