package fr.ifremer.coser.ui.selection;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.ui.result.ResultTableModel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SelectionRsufiView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTION_RESULTS_TABLE_MODEL = "selectionResultsTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECTION_RESULTS_TABLE_MODEL = "selectionResultsTable.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRQeKm0pyK8WKioa1OrFuOVHjAdQQaAiFjWUGGJj4rQ70CHb3XVmVtaL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb6ZbXe7sJQm7WG6O+9933zvzdvv/S8U5wxd2MOuqzHHFLROtPWl7e2HlT1SFSuEVxm1hcWQ9+uJoVgZDej+PhfoUrko4fkGPL9s1W3LJGYLer6I+rl4aRBeI0QIdC6MqHKeL/nhedd2WJPVFxXF+vbP79gb/fW7GEKuDerSUMrUcaigkt4iilFdoDSc9ALnDWzuggxGzV3QOyj3lg3M+QNcJ8/RK5QsooSNGZAJdLHzkhWHwru2QMncFq4YZFqg6R2m0R1G6oRpVYvD6lCNEwPaTi1TKzWfNrmzQx9Tsm/biiYBJDVs6gZhAmkdkqx5gBYKT8eMQBOhhvF9KF9TMZmZ8gGp3PodRwjLBOkZ2Ru3kdvYlmnDB+ln5etomKgvt17EFWIATzrEo3Zl0rifm2WEO4ZYdQXDMI1Y4AIlBlxZNoTcIq5QgTDalzwjN8aOCM5GBEHjI2xGaFS74Xoapc5FlDqYWy9VmWUYEgZcp0JcQUim53zUGf/+NlX1XPFvWDoxBLoadeFelzQvPcgObns8kvJgcf6tX/GBY7ki5cIfI0ULhZxvxR3OCA5OwxsRxDs1GJSxcMUjRKfimBz/vuZagwydDY0vOIkWOEnwqfeUUZw5sA3zXj5sPpsQ8mxn4oDtSEIV/ZfNfP/082Oh6TVDcPZ4ZGqLVYIH2Myy4Uul8uhhz2gcQY38BrbnyyjlXYzy0ckIYaVGGMTBeaMSrkm4toZ5DSjiyR+fv2SffTuBYgXUb1hYL2CZfw+lRA3GomYZumvfXlSKTu73wToitQmUqFhMlxYytKDDdzVVoaYOt3nLhSZMRjTBV1JJff2bKX1YbDaiB4SdPjI9aEb8CUpQ06AmUbbbcNRImx2wOXF0K3DOKC/tkf8jdmPWbqp1KarSXgH2AKO44J0+hQV4fMURBGqVoFVVhHy6qzgzx3LK7WW5rEQzZDtiuC+XYjTDRNcM5zvoTJKY8pPX25Qy1bWQzhjatfNyB6XE69J42pBc60jG0zaFzHXdis4Y2mm43rWG7hluAMN/3dLlHjgKAAA=";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(SelectionRsufiView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton deleteResultButton;
    protected JButton editResultButton;
    protected SelectionHandler handler;
    protected JTextField resultExtractDataField;
    protected JTable selectionResultsTable;
    protected ResultTableModel selectionResultsTableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private SelectionRsufiView $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
                fr.ifremer.coser.ui.result.ResultTableRenderer renderer = new fr.ifremer.coser.ui.result.ResultTableRenderer(this);
                selectionResultsTable.setDefaultRenderer(Object.class, renderer);
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionRsufiView() {
        $initialize();
    }

    public SelectionRsufiView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectionFilesEdit(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectOutputDirectory(this, resultExtractDataField);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().extractRSufiData(this);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAddResultDialog(this);
    }

    public void doActionPerformed__on__deleteResultButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteResult(this);
    }

    public void doActionPerformed__on__editResultButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showEditResultDialog(this);
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editResultButton.setEnabled(getSelectionResultsTable().getSelectedRow() != -1);deleteResultButton.setEnabled(getSelectionResultsTable().getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getDeleteResultButton() {
        return deleteResultButton;
    }

    public JButton getEditResultButton() {
        return editResultButton;
    }

    public SelectionHandler getHandler() {
        return handler;
    }

    public JTextField getResultExtractDataField() {
        return resultExtractDataField;
    }

    public JTable getSelectionResultsTable() {
        return selectionResultsTable;
    }

    public ResultTableModel getSelectionResultsTableModel() {
        return selectionResultsTableModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(SelectionHandler handler) {
        SelectionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectionResultsTableModel(ResultTableModel selectionResultsTableModel) {
        ResultTableModel oldValue = this.selectionResultsTableModel;
        this.selectionResultsTableModel = selectionResultsTableModel;
        firePropertyChange(PROPERTY_SELECTION_RESULTS_TABLE_MODEL, oldValue, selectionResultsTableModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDeleteResultButton() {
        $objectMap.put("deleteResultButton", deleteResultButton = new JButton());
        
        deleteResultButton.setName("deleteResultButton");
        deleteResultButton.setEnabled(false);
        deleteResultButton.setText(t("coser.ui.result.deleteResult"));
        deleteResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteResultButton"));
    }

    protected void createEditResultButton() {
        $objectMap.put("editResultButton", editResultButton = new JButton());
        
        editResultButton.setName("editResultButton");
        editResultButton.setEnabled(false);
        editResultButton.setText(t("coser.ui.result.editResult"));
        editResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editResultButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createResultExtractDataField() {
        $objectMap.put("resultExtractDataField", resultExtractDataField = new JTextField());
        
        resultExtractDataField.setName("resultExtractDataField");
        resultExtractDataField.setColumns(15);
    }

    protected void createSelectionResultsTable() {
        $objectMap.put("selectionResultsTable", selectionResultsTable = new JTable());
        
        selectionResultsTable.setName("selectionResultsTable");
    }

    protected void createSelectionResultsTableModel() {
        $objectMap.put("selectionResultsTableModel", selectionResultsTableModel = new fr.ifremer.coser.ui.result.ResultTableModel(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(30, 30, 30, 30), 0, 0));
        add($Table3, new GridBagConstraints(0, 3, 1, 1, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(resultExtractDataField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton2, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JScrollPane0, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(deleteResultButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(editResultButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(selectionResultsTable);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(t("coser.ui.selection.option.optionTitle")));
        $Table2.setBorder(BorderFactory.createTitledBorder(t("coser.ui.result.extractDataTitle")));
        $Table3.setBorder(BorderFactory.createTitledBorder(t("coser.ui.result.availableDataTitle")));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("coser.ui.selection.option.editFiles"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("coser.ui.result.extractDataLabel"));
        createResultExtractDataField();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("coser.ui.common.selectFile"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("coser.ui.result.extractDataButton"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSelectionResultsTableModel();
        createSelectionResultsTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = selectionResultsTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createDeleteResultButton();
        createEditResultButton();
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(t("coser.ui.result.addNewResult"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (resultExtractDataField != null) {
                    $bindingSources.put("resultExtractDataField.getDocument()", resultExtractDataField.getDocument());
                    resultExtractDataField.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    resultExtractDataField.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionRsufiView.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (resultExtractDataField != null && resultExtractDataField.getText() != null) {
                    $JButton2.setEnabled(!resultExtractDataField.getText().isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (resultExtractDataField != null) {
                    Document $target = (Document) $bindingSources.remove("resultExtractDataField.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    resultExtractDataField.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionRsufiView.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTION_RESULTS_TABLE_MODEL, true ,"selectionResultsTableModel") {
        
            @Override
            public void processDataBinding() {
                selectionResultsTable.setModel(getSelectionResultsTableModel());
            }
        });
    }

}