/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.widgets;

import fr.ifremer.coser.ui.widgets.AccordionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AccordionPaneSubPanel
extends JPanel {
    private static final long serialVersionUID = 4836598811061630517L;
    protected AccordionPane accordionPane;
    protected JPanel titlePanel;
    protected JLabel titleLabel;
    protected JComponent child;
    protected int index;
    protected Cursor handCursor = null;
    protected int mousePressedInd = -1;

    public AccordionPaneSubPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        if (this.handCursor == null) {
            this.handCursor = new Cursor(12);
        }
        this.setLayout(new BorderLayout());
    }

    public void setAccordionPane(AccordionPane accordionPane) {
        this.accordionPane = accordionPane;
        if (this.titlePanel != null) {
            this.titlePanel.setBackground(accordionPane.paneBackgroundColor);
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public JPanel getTitlePanel() {
        return this.titlePanel;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitle(String title) {
        this.titleLabel = new JLabel(title);
        this.titlePanel = new JPanel();
        this.titlePanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.add((Component)this.titleLabel, "West");
        if (this.accordionPane != null) {
            this.titlePanel.setBackground(this.accordionPane.paneBackgroundColor);
        }
        this.titlePanel.setCursor(this.handCursor);
        this.add((Component)this.titlePanel, "North");
        this.titlePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                if (AccordionPaneSubPanel.this.accordionPane.selected != AccordionPaneSubPanel.this.index) {
                    AccordionPaneSubPanel.this.accordionPane.setSelected(AccordionPaneSubPanel.this.index);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                AccordionPaneSubPanel.this.mousePressedInd = AccordionPaneSubPanel.this.index;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (AccordionPaneSubPanel.this.mousePressedInd == AccordionPaneSubPanel.this.index && AccordionPaneSubPanel.this.accordionPane.selected != AccordionPaneSubPanel.this.index) {
                    AccordionPaneSubPanel.this.accordionPane.setSelected(AccordionPaneSubPanel.this.index);
                }
                AccordionPaneSubPanel.this.mousePressedInd = -1;
            }
        });
    }

    @Override
    public Component add(Component child) {
        this.add(child, "Center");
        return child;
    }
}

