/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.option;

import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.option.ConfigurationView;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationHandler
extends CommonHandler {
    private static final Log log = LogFactory.getLog(ConfigurationHandler.class);

    public void selectInputDirectory(ConfigurationView configurationView, JTextField textComponent) {
        CoserConfig config = configurationView.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getDatabaseDirectory());
        selectFileChooser.setFileSelectionMode(1);
        int result = selectFileChooser.showOpenDialog(configurationView);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }

    public void selectInputFile(ConfigurationView configurationView, JTextField textComponent) {
        CoserConfig config = configurationView.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getDatabaseDirectory());
        selectFileChooser.setFileSelectionMode(0);
        int result = selectFileChooser.showOpenDialog(configurationView);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }

    public void saveConfiguration(ConfigurationView configurationView) {
        Window[] windows;
        CoserConfig config;
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                config = configurationView.getContextValue(CoserConfig.class);
                                config.setProjectsDirectory(configurationView.getProjectDirectoryField().getText());
                                config.setValidatorsDirectory(configurationView.getValidatorDirectoryField().getText());
                                config.setReferenceSpeciesPath(configurationView.getReferenceSpeciesField().getText());
                                config.setReferenceTypeEspecesPath(configurationView.getReferenceTypeEspecesField().getText());
                                config.setWebZonesFile(configurationView.getWebZonesField().getText());
                                config.setWebFrontEnd(configurationView.getWebFrontEndField().getText());
                                try {
                                    config.setControlNobsmin(Double.parseDouble(configurationView.getControlNobsMinField().getText()));
                                }
                                catch (NumberFormatException ex) {
                                    if (!log.isWarnEnabled()) break block13;
                                    log.warn((Object)"Can't parse number", (Throwable)ex);
                                }
                            }
                            try {
                                config.setControlDiffCatchLength(Double.parseDouble(configurationView.getControlDiffCatchLengthField().getText()));
                            }
                            catch (NumberFormatException ex) {
                                if (!log.isWarnEnabled()) break block14;
                                log.warn((Object)"Can't parse number", (Throwable)ex);
                            }
                        }
                        config.setControlTypeFish(configurationView.getControlTypeFishField().getText());
                        try {
                            config.setStandardDeviationToAverage(Integer.parseInt(configurationView.getControlStandardDeviationField().getText()));
                        }
                        catch (NumberFormatException ex) {
                            if (!log.isWarnEnabled()) break block15;
                            log.warn((Object)"Can't parse number", (Throwable)ex);
                        }
                    }
                    try {
                        config.setSelectionDensityFilter(Double.parseDouble(configurationView.getSelectionFilterDensityField().getText()));
                    }
                    catch (NumberFormatException ex) {
                        if (!log.isWarnEnabled()) break block16;
                        log.warn((Object)"Can't parse number", (Throwable)ex);
                    }
                }
                try {
                    config.setSelectionOccurrenceFilter(Double.parseDouble(configurationView.getSelectionFilterOccurrenceField().getText()));
                }
                catch (NumberFormatException ex) {
                    if (!log.isWarnEnabled()) break block17;
                    log.warn((Object)"Can't parse number", (Throwable)ex);
                }
            }
            config.setSmtpHost(configurationView.getSmtpHostField().getText());
            config.setSupportEmail(configurationView.getSupportEmailField().getText());
            try {
                config.setSwingFontSize(Integer.parseInt((String)configurationView.getSwingFontSizeField().getSelectedItem()));
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) break block18;
                log.warn((Object)"Can't parse number", (Throwable)ex);
            }
        }
        config.saveForUser(new String[0]);
        configurationView.dispose();
        for (Window window : windows = Frame.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }
}

