package fr.ifremer.coser.ui.selection;

/*
 * #%L
 * Coser :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.bbn.openmap.InformationDelegator;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.ui.maps.CoserMap;
import fr.ifremer.coser.ui.selection.model.SpeciesListModel;
import fr.ifremer.coser.ui.selection.model.SpeciesTypesListModel;
import fr.ifremer.coser.ui.selection.model.StrataListModel;
import fr.ifremer.coser.ui.selection.model.YearListModel;
import fr.ifremer.coser.ui.util.CoserListSelectionModel;
import fr.ifremer.coser.ui.widgets.AccordionPane;
import fr.ifremer.coser.ui.widgets.AccordionPaneSubPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import static org.nuiton.i18n.I18n._;

public class SelectionDetailsView extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CREATION_STATE = "creationState";
    public static final String PROPERTY_FILTERED_SPECIES_LIST_SELECTION_MODEL = "filteredSpeciesListSelectionModel";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_SPECIES_LIST_SELECTION_MODEL = "selectedSpeciesListSelectionModel";
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SPECIES_VALIDATED = "speciesValidated";
    public static final String PROPERTY_STRATA_VALIDATED = "strataValidated";
    public static final String PROPERTY_YEARS_LIST_SELECTION_MODEL = "yearsListSelectionModel";
    public static final String PROPERTY_YEARS_VALIDATED = "yearsValidated";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DETAILS_COMMENT_TEXT = "detailsComment.text";
    public static final String BINDING_DETAILS_DESCRIPTION_TEXT = "detailsDescription.text";
    public static final String BINDING_DETAILS_SELECTION_NAME_FIELD_ENABLED = "detailsSelectionNameField.enabled";
    public static final String BINDING_DETAILS_SELECTION_NAME_FIELD_TEXT = "detailsSelectionNameField.text";
    public static final String BINDING_FILTERED_SPECIES_LIST_ENABLED = "filteredSpeciesList.enabled";
    public static final String BINDING_FILTERED_SPECIES_LIST_SELECTION_MODEL = "filteredSpeciesList.selectionModel";
    public static final String BINDING_SELECTED_SPECIES_LIST_ENABLED = "selectedSpeciesList.enabled";
    public static final String BINDING_SELECTED_SPECIES_LIST_SELECTION_MODEL = "selectedSpeciesList.selectionModel";
    public static final String BINDING_STRATA_LIST_SELECTION_MODEL = "strataList.selectionModel";
    public static final String BINDING_TYPE_SPECIES_LABEL_TEXT = "typeSpeciesLabel.text";
    public static final String BINDING_TYPE_SPECIES_LIST_ENABLED = "typeSpeciesList.enabled";
    public static final String BINDING_TYPE_SPECIES_LIST_SELECTION_MODEL = "typeSpeciesList.selectionModel";
    public static final String BINDING_VALID_DATES_BUTTON_ENABLED = "validDatesButton.enabled";
    public static final String BINDING_VALID_SPECIES_BUTTON_ENABLED = "validSpeciesButton.enabled";
    public static final String BINDING_VALID_STRATA_BUTTON_ENABLED = "validStrataButton.enabled";
    public static final String BINDING_YEARS_LIST_SELECTION_MODEL = "yearsList.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";
    private static final String BINDING_$JBUTTON5_ENABLED = "$JButton5.enabled";
    private static final String BINDING_$JBUTTON8_ENABLED = "$JButton8.enabled";
    private static final String BINDING_$JBUTTON9_ENABLED = "$JButton9.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYXWwVRRSeVkppgdIfQIiggFcTg27pH/8BiqVA0ypyawM0GubenbaL+8fuXHqrEUn0yUhC9MGYmCgvxhh80Bhj4l+IJuKbxvig0UTjg74Q44OvxjO7987c3Tt37pTtw7adc8433/nOmdmZvXEbtYUB2n4Bl8tGUHKp5RBjYvTMmccLF0iRjpGwGFg+9QIU/7S0otZZtNrk4yFF989OsvD+Snj/o57jey5xa6IPTKLOkC7ZJFwghFK0NRlRDMP+PDcfKPuloIrKSclQ3/7n79Zr5pXrrQiVfWA3A6lsaxYlMlkxiVotk6JemOkS7rexOw80AsudB75r2dijNg7Dx7BDLqLLqH0SrfRxAGAU7dBPOcKI4ss+Re25aVywyS6KBucCw5oLiEMCo+iF8CxZRkhskN3yXCNf/WuMUGzZ4YxFFn0/AloJMAvYNW0SUGRowpyIAwTE2mJAMLPkKaaEoh6WsMFEMI56nk2wK3y7lggOwhlsWyb4mmy0R1jXhTTAFDcyd4c+KVqkYXgHZ0vRfXXZFICIyKIGlQQBtF+k5pRnEpuig4nSX4qn8wIjXISSGnn2nKkOTpEwxPNEhAvkXh6ZF8R2LgNbQHXmJqZBy6M4gIKvZwKXKxHVcebYIaTITRwtUeq54N6XcI+Hmdt27r2eo+fyBDqTzQ2B98rmER5JDD7jABt4MGlcneONDbi9UYPgRSpWVdK9L8SXCNdMME6hrslN5H3boqewy9bBxgRdbkkK02dGq2C0WPQCE8CZB0UPyXp/0TLnCQ2NhC+DGeBod+cSxnypwH7ZQGZAG7EaxCCHxbqMl/cARZsSDRNnF9mY5x4esCo3MYkL0dy9CSGiUea0n/tujkUIucRsZxq3iG2mVZwmZRoZkgCduTGvWHLicm6ujaAQYFSNfh27qDkOJ8HWV9hUtzy2k5wCbZPlLAaebVcrIIJ764Mp2lCXwyhsUSzihCSFiNOxeq6DEq7dlemgcVlo/hQbn0j6dCV92OgUe5yWzD2YmrtBQ0UU90k7JEI4yB5n6jIY4hmcE7t1rkbLXZz+udQWPWmFtLIbSltZvBgc5mWchSAeU7Mlc7DKe0G0JYwxp6dF7tyX92WFQWIjqneo2cuj/XQM3g1hatc410ziwcYSD3GJnxE7Wvyq4osrUtmRqzzAVRYOlVddjcxDOjLnk1E1LwiBx0aiVXKxfnMe5II49cYhibEnUjSeNiWp00zSocaSDnNJL4vi0SWf5ONXfFLXK3JdB7muV6QgFWH3aQkbh0xDdCiRd10tt1qNX0opNW7ZlAQppa6k0x/h6QvT+rkolJhSCa4Kv5h6U7+EVENcKuGwKT2h6MXhZUgmUatPgswVe427bZe4JVc2c1zw0+rt5updrW/iYa76m/XGEYmRnSJqDj2pU0TtYUcCuFs12x6Vca/KuE9iTNRzWFbPdGNUC8Psr9dUR+LHq/O+qI7ETVmd6ltnWNKM8VG4gtRwdVTOJWPgFVb2EnsSL3ngH59i40MjDsx4tCYnSWT6IMRPWQNyTUe4pp+lO24P77gv69Id4eneFHuBg+H6V45mPGZa0D8UPewF84Zbgn9gAWG6YMQ+xjwsram0exIOporPlez/L5IMO+KNfwr7bEFJlq2D/RAO2vAf+LCgW6L1QxqHnnTnPIpyRc8xCgXX8HziQpjBhgMHx5dHm8xXF8ItuYC7JQL2VO5sxwPsL/AKRDl858Mt+57E6Rbu74a4v4sLdsssagtKMAxdPlt/5T8Npviyvyl12WeAkfW/jX0/fvrLR+PVG/4EzL1B6lrzgQJu3n4AYgTUYlOvi6/3JWrZ/SDagdnqjTP6erFFQixfMQM5mC++GLNw4wQOFwCirf3nm19tPP/9Xah1HHXaHjbHMfM/iTroQgAqeLZZ9g8fiRitWVwFz27GDco+B96U9Sa0+UHLtS2XbMMU2qhQouRQGbTYItGCEyp0fPNvX/6DI1U9WoDf5obuQpO2c2hlPFv0zYPVsb3BN47VfkhKpic+W8g+ZLSw3zv8ykr+KXr+Kkt4hVVkR/uug3AzxtsKlmvCooY8WcDvUQLsrz8ivAd08NhNhVl/u1MMNvwne/wlR9iphXBbwUEPQcVhV2YOzRHgMOxYruWUnLz1LFGQGdGAaqMWja+2DfjszZzRIQ0a7cRla8tUZDOqTyQ7QoNUjus0euAthgqMycx5LAOhAYcndBBatioQnsychRZCS7uCw9nMOjyls0Kc6tmrQSKmBkhXWHeSu2M0Jku3AuFCZlm0EJSlsTO3h6/FYb8CYVEL4XBWBOX7YElnN6eeZ09b/rT6BdkcqhmZ57QEOa/goIegas7nMzenFoKyOV/I3JwvapR1TZHY9mnimnDjDhRYL2fWVA9BtVT0EFRLZRlZNKjKK5k7YxkIDbK4lhnh1czVfCNzNfUQVNXUQ1Bl8Vbm3UoLQblb6SGosrieOQstBGUW2Tm8k5mDFoKSw7uZOeghqKr5XuYstBCUWeghqLK4kTkLLQRlFnoIqiw+zLzL6SGodrnmCBR1znkufST6jKLQ4+PM7y4tBKWin2Tm0ByBopV29CVYwePzzDy+1kFobVdw+DYzwg+A8D+d0YFsZCUAAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    private static final Log log = LogFactory.getLog(SelectionDetailsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean creationState;
    protected AccordionPane detailAccordionPane;
    protected JPanel detailDecisionPanel;
    protected CardLayout detailDecisionPanelLayout;
    protected JTextArea detailsComment;
    protected JScrollPane detailsCommentSP;
    protected JTextArea detailsDescription;
    @ValidatorField( validatorId = "validatorSelection",  propertyName = "description",  editorName = "detailsDescriptionSP")
    protected JScrollPane detailsDescriptionSP;
    @ValidatorField( validatorId = "validatorSelection",  propertyName = "name",  editorName = "detailsSelectionNameField")
    protected JTextField detailsSelectionNameField;
    protected SwingValidatorMessageTableModel errorsTableModel;
    protected JLabel filteredSpeciesLabel;
    protected JList filteredSpeciesList;
    protected SpeciesListModel filteredSpeciesListModel;
    protected ListSelectionModel filteredSpeciesListSelectionModel;
    protected SelectionHandler handler;
    protected MatrixPanelEditor matrixPanelEditor;
    protected JButton saveSelectionButton;
    protected JLabel selectedSpeciesLabel;
    protected JList selectedSpeciesList;
    protected SpeciesListModel selectedSpeciesListModel;
    protected ListSelectionModel selectedSpeciesListSelectionModel;
    protected Selection selection;
    protected JPanel speciesGraphPanel;
    protected Boolean speciesValidated;
    protected InformationDelegator stataMapInfo;
    protected JLabel strataLabel;
    protected JList strataList;
    protected StrataListModel strataListModel;
    protected CoserMap strataMap;
    protected Boolean strataValidated;
    protected JLabel typeSpeciesLabel;
    protected JList typeSpeciesList;
    protected SpeciesTypesListModel typeSpeciesModel;
    protected JButton validDatesButton;
    protected JButton validFilterButton;
    protected JButton validSpeciesButton;
    protected JButton validStrataButton;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSelection")
    protected SwingValidator<Selection> validatorSelection;
    protected JList yearsList;
    protected YearListModel yearsListModel;
    protected ListSelectionModel yearsListSelectionModel;
    protected Boolean yearsValidated;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccordionPaneSubPanel $AccordionPaneSubPanel0;
    private AccordionPaneSubPanel $AccordionPaneSubPanel1;
    private AccordionPaneSubPanel $AccordionPaneSubPanel2;
    private AccordionPaneSubPanel $AccordionPaneSubPanel3;
    private Component $Component0;
    private Document $Document0;
    private Document $Document1;
    private Document $Document2;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private JButton $JButton7;
    private JButton $JButton8;
    private JButton $JButton9;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private JScrollPane $JScrollPane4;
    private JScrollPane $JScrollPane5;
    private JScrollPane $JScrollPane6;
    private JSeparator $JSeparator0;
    private JSplitPane $JSplitPane0;
    private Separator $JToolBar$Separator0;
    private JToolBar $JToolBar0;
    private SelectionDetailsView $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    private Table $Table5;
    private Table $Table6;
    private Table $Table7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
                // modification (species -> selection model)
                filteredSpeciesListModel.addListDataListener((CoserListSelectionModel)filteredSpeciesList.getSelectionModel());
                selectedSpeciesListModel.addListDataListener((CoserListSelectionModel)selectedSpeciesList.getSelectionModel());
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionDetailsView() {
        $initialize();
    }

    public SelectionDetailsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().displayLogReport(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().reloadControlData(this);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDetailDecisionPanelLayout().show(getDetailDecisionPanel(), "ZONEMAP");getHandler().showStataOnMap(this);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDetailDecisionPanelLayout().show(getDetailDecisionPanel(), "SPECIESDATA");getHandler().showSamplingEffort(this);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addSelectedFilteredSpecies(this);
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeSelectedSpecies(this);
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectAllListSpecies(this);
    }

    public void doActionPerformed__on__$JButton7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().unSelectAllListSpecies(this);
    }

    public void doActionPerformed__on__$JButton8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectedSpeciesGraph(this, null);
    }

    public void doActionPerformed__on__$JButton9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSpeciesMergeDialog(this);
    }

    public void doActionPerformed__on__saveSelectionButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveSelection(this);
    }

    public void doActionPerformed__on__validDatesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionYearsData(this);setYearsValidated(true);
    }

    public void doActionPerformed__on__validFilterButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateSelectionSpecies(this);validFilterButton.setEnabled(false);
    }

    public void doActionPerformed__on__validSpeciesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionSpeciesData(this);setSpeciesValidated(true);saveSelectionButton.setEnabled(getErrorsTableModel().getRowCount() == 0);
    }

    public void doActionPerformed__on__validStrataButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionStrataData(this);setStrataValidated(true);
    }

    public void doContentsChanged__on__filteredSpeciesListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filteredSpeciesLabel.setText(_("coser.ui.selection.details.filteredSpecies", filteredSpeciesList.getSelectedIndices().length, filteredSpeciesList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectedSpeciesListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSpeciesValidated(false);selectedSpeciesLabel.setText(_("coser.ui.selection.details.selectedSpecies", selectedSpeciesList.getSelectedIndices().length, selectedSpeciesList.getModel().getSize()));
    }

    public void doContentsChanged__on__strataListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        strataLabel.setText(_("coser.ui.selection.details.strata", strataList.getSelectedIndices().length, strataList.getModel().getSize()));
    }

    public void doContentsChanged__on__typeSpeciesModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        typeSpeciesLabel.setText(_("coser.ui.selection.details.type", typeSpeciesList.getSelectedIndices().length, typeSpeciesList.getModel().getSize()));
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setName(detailsSelectionNameField.getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setDescription(detailsDescription.getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setComment(detailsComment.getText());
    }

    public void doMouseClicked__on__filteredSpeciesList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFilteredSpeciesContextMenu(this, event);
    }

    public void doMouseClicked__on__selectedSpeciesList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectedSpeciesContextMenu(this, event);
    }

    public void doMouseClicked__on__strataList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showStrataContextMenu(this, event);
    }

    public void doMouseClicked__on__yearsList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showYearsContextMenu(this, event);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setName(detailsSelectionNameField.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setDescription(detailsDescription.getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setComment(detailsComment.getText());
    }

    public void doTableChanged__on__errorsTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveSelectionButton.setEnabled(getErrorsTableModel().getRowCount() == 0 && isSpeciesValidated());
    }

    public void doValueChanged__on__filteredSpeciesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filteredSpeciesLabel.setText(_("coser.ui.selection.details.filteredSpecies", filteredSpeciesList.getSelectedIndices().length, filteredSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__selectedSpeciesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        selectedSpeciesLabel.setText(_("coser.ui.selection.details.selectedSpecies", selectedSpeciesList.getSelectedIndices().length, selectedSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__strataList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setStrataValidated(false); strataLabel.setText(_("coser.ui.selection.details.strata", strataList.getSelectedIndices().length, strataList.getModel().getSize()));
    }

    public void doValueChanged__on__typeSpeciesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validFilterButton.setEnabled(true); typeSpeciesLabel.setText(_("coser.ui.selection.details.type", typeSpeciesList.getSelectedIndices().length, typeSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__yearsList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setYearsValidated(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getCreationState() {
        return creationState;
    }

    public AccordionPane getDetailAccordionPane() {
        return detailAccordionPane;
    }

    public JPanel getDetailDecisionPanel() {
        return detailDecisionPanel;
    }

    public CardLayout getDetailDecisionPanelLayout() {
        return detailDecisionPanelLayout;
    }

    public JTextArea getDetailsComment() {
        return detailsComment;
    }

    public JScrollPane getDetailsCommentSP() {
        return detailsCommentSP;
    }

    public JTextArea getDetailsDescription() {
        return detailsDescription;
    }

    public JScrollPane getDetailsDescriptionSP() {
        return detailsDescriptionSP;
    }

    public JTextField getDetailsSelectionNameField() {
        return detailsSelectionNameField;
    }

    public SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public JLabel getFilteredSpeciesLabel() {
        return filteredSpeciesLabel;
    }

    public JList getFilteredSpeciesList() {
        return filteredSpeciesList;
    }

    public SpeciesListModel getFilteredSpeciesListModel() {
        return filteredSpeciesListModel;
    }

    public ListSelectionModel getFilteredSpeciesListSelectionModel() {
        return filteredSpeciesListSelectionModel;
    }

    public SelectionHandler getHandler() {
        return handler;
    }

    public MatrixPanelEditor getMatrixPanelEditor() {
        return matrixPanelEditor;
    }

    public JButton getSaveSelectionButton() {
        return saveSelectionButton;
    }

    public JLabel getSelectedSpeciesLabel() {
        return selectedSpeciesLabel;
    }

    public JList getSelectedSpeciesList() {
        return selectedSpeciesList;
    }

    public SpeciesListModel getSelectedSpeciesListModel() {
        return selectedSpeciesListModel;
    }

    public ListSelectionModel getSelectedSpeciesListSelectionModel() {
        return selectedSpeciesListSelectionModel;
    }

    public Selection getSelection() {
        return selection;
    }

    public JPanel getSpeciesGraphPanel() {
        return speciesGraphPanel;
    }

    public Boolean getSpeciesValidated() {
        return speciesValidated;
    }

    public InformationDelegator getStataMapInfo() {
        return stataMapInfo;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public JList getStrataList() {
        return strataList;
    }

    public StrataListModel getStrataListModel() {
        return strataListModel;
    }

    public CoserMap getStrataMap() {
        return strataMap;
    }

    public Boolean getStrataValidated() {
        return strataValidated;
    }

    public JLabel getTypeSpeciesLabel() {
        return typeSpeciesLabel;
    }

    public JList getTypeSpeciesList() {
        return typeSpeciesList;
    }

    public SpeciesTypesListModel getTypeSpeciesModel() {
        return typeSpeciesModel;
    }

    public JButton getValidDatesButton() {
        return validDatesButton;
    }

    public JButton getValidFilterButton() {
        return validFilterButton;
    }

    public JButton getValidSpeciesButton() {
        return validSpeciesButton;
    }

    public JButton getValidStrataButton() {
        return validStrataButton;
    }

    public SwingValidator<Selection> getValidatorSelection() {
        return validatorSelection;
    }

    public JList getYearsList() {
        return yearsList;
    }

    public YearListModel getYearsListModel() {
        return yearsListModel;
    }

    public ListSelectionModel getYearsListSelectionModel() {
        return yearsListSelectionModel;
    }

    public Boolean getYearsValidated() {
        return yearsValidated;
    }

    public Boolean isCreationState() {
        return creationState !=null && creationState;
    }

    public Boolean isSpeciesValidated() {
        return speciesValidated !=null && speciesValidated;
    }

    public Boolean isStrataValidated() {
        return strataValidated !=null && strataValidated;
    }

    public Boolean isYearsValidated() {
        return yearsValidated !=null && yearsValidated;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void setCreationState(Boolean creationState) {
        Boolean oldValue = this.creationState;
        this.creationState = creationState;
        firePropertyChange(PROPERTY_CREATION_STATE, oldValue, creationState);
    }

    public void setFilteredSpeciesListSelectionModel(ListSelectionModel filteredSpeciesListSelectionModel) {
        ListSelectionModel oldValue = this.filteredSpeciesListSelectionModel;
        this.filteredSpeciesListSelectionModel = filteredSpeciesListSelectionModel;
        firePropertyChange(PROPERTY_FILTERED_SPECIES_LIST_SELECTION_MODEL, oldValue, filteredSpeciesListSelectionModel);
    }

    public void setHandler(SelectionHandler handler) {
        SelectionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedSpeciesListSelectionModel(ListSelectionModel selectedSpeciesListSelectionModel) {
        ListSelectionModel oldValue = this.selectedSpeciesListSelectionModel;
        this.selectedSpeciesListSelectionModel = selectedSpeciesListSelectionModel;
        firePropertyChange(PROPERTY_SELECTED_SPECIES_LIST_SELECTION_MODEL, oldValue, selectedSpeciesListSelectionModel);
    }

    public void setSelection(Selection selection) {
        Selection oldValue = this.selection;
        this.selection = selection;
        firePropertyChange(PROPERTY_SELECTION, oldValue, selection);
    }

    public void setSpeciesValidated(Boolean speciesValidated) {
        Boolean oldValue = this.speciesValidated;
        this.speciesValidated = speciesValidated;
        firePropertyChange(PROPERTY_SPECIES_VALIDATED, oldValue, speciesValidated);
    }

    public void setStrataValidated(Boolean strataValidated) {
        Boolean oldValue = this.strataValidated;
        this.strataValidated = strataValidated;
        firePropertyChange(PROPERTY_STRATA_VALIDATED, oldValue, strataValidated);
    }

    public void setYearsListSelectionModel(ListSelectionModel yearsListSelectionModel) {
        ListSelectionModel oldValue = this.yearsListSelectionModel;
        this.yearsListSelectionModel = yearsListSelectionModel;
        firePropertyChange(PROPERTY_YEARS_LIST_SELECTION_MODEL, oldValue, yearsListSelectionModel);
    }

    public void setYearsValidated(Boolean yearsValidated) {
        Boolean oldValue = this.yearsValidated;
        this.yearsValidated = yearsValidated;
        firePropertyChange(PROPERTY_YEARS_VALIDATED, oldValue, yearsValidated);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected AccordionPaneSubPanel get$AccordionPaneSubPanel0() {
        return $AccordionPaneSubPanel0;
    }

    protected AccordionPaneSubPanel get$AccordionPaneSubPanel1() {
        return $AccordionPaneSubPanel1;
    }

    protected AccordionPaneSubPanel get$AccordionPaneSubPanel2() {
        return $AccordionPaneSubPanel2;
    }

    protected AccordionPaneSubPanel get$AccordionPaneSubPanel3() {
        return $AccordionPaneSubPanel3;
    }

    protected Component get$Component0() {
        return $Component0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JButton get$JButton7() {
        return $JButton7;
    }

    protected JButton get$JButton8() {
        return $JButton8;
    }

    protected JButton get$JButton9() {
        return $JButton9;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    protected Table get$Table6() {
        return $Table6;
    }

    protected Table get$Table7() {
        return $Table7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDetailAccordionPane() {
        if (!allComponentsCreated) {
            return;
        }
        detailAccordionPane.add($AccordionPaneSubPanel0);
        detailAccordionPane.add($AccordionPaneSubPanel1);
        detailAccordionPane.add($AccordionPaneSubPanel2);
        detailAccordionPane.add($AccordionPaneSubPanel3);
    }

    protected void addChildrenToDetailDecisionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        detailDecisionPanel.add($JScrollPane5, "SPECIESDATA");
        detailDecisionPanel.add($JPanel0, "ZONEMAP");
        detailDecisionPanel.add($JScrollPane6, "SPECIESGRAPH");
    }

    protected void addChildrenToDetailsCommentSP() {
        if (!allComponentsCreated) {
            return;
        }
        detailsCommentSP.getViewport().add(detailsComment);
    }

    protected void addChildrenToDetailsDescriptionSP() {
        if (!allComponentsCreated) {
            return;
        }
        detailsDescriptionSP.getViewport().add(detailsDescription);
    }

    protected void addChildrenToValidatorSelection() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSelection.setErrorTableModel(errorsTableModel);
        validatorSelection.setUiClass(ImageValidationUI.class);
        validatorSelection.setBean(selection);
    }

    protected void createCreationState() {
        $objectMap.put("creationState", creationState = false);
    }

    protected void createDetailAccordionPane() {
        $objectMap.put("detailAccordionPane", detailAccordionPane = new AccordionPane());
        
        detailAccordionPane.setName("detailAccordionPane");
    }

    protected void createDetailDecisionPanel() {
        $objectMap.put("detailDecisionPanel", detailDecisionPanel = new JPanel());
        
        detailDecisionPanel.setName("detailDecisionPanel");
        detailDecisionPanel.setLayout(detailDecisionPanelLayout);
    }

    protected void createDetailDecisionPanelLayout() {
        $objectMap.put("detailDecisionPanelLayout", detailDecisionPanelLayout = new CardLayout());
    }

    protected void createDetailsComment() {
        $objectMap.put("detailsComment", detailsComment = new JTextArea());
        
        detailsComment.setName("detailsComment");
        detailsComment.setColumns(15);
        detailsComment.setLineWrap(true);
        detailsComment.setWrapStyleWord(true);
        detailsComment.setRows(3);
    }

    protected void createDetailsCommentSP() {
        $objectMap.put("detailsCommentSP", detailsCommentSP = new JScrollPane());
        
        detailsCommentSP.setName("detailsCommentSP");
    }

    protected void createDetailsDescription() {
        $objectMap.put("detailsDescription", detailsDescription = new JTextArea());
        
        detailsDescription.setName("detailsDescription");
        detailsDescription.setColumns(15);
        detailsDescription.setLineWrap(true);
        detailsDescription.setWrapStyleWord(true);
        detailsDescription.setRows(3);
    }

    protected void createDetailsDescriptionSP() {
        $objectMap.put("detailsDescriptionSP", detailsDescriptionSP = new JScrollPane());
        
        detailsDescriptionSP.setName("detailsDescriptionSP");
    }

    protected void createDetailsSelectionNameField() {
        $objectMap.put("detailsSelectionNameField", detailsSelectionNameField = new JTextField());
        
        detailsSelectionNameField.setName("detailsSelectionNameField");
        detailsSelectionNameField.setColumns(15);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createFilteredSpeciesLabel() {
        $objectMap.put("filteredSpeciesLabel", filteredSpeciesLabel = new JLabel());
        
        filteredSpeciesLabel.setName("filteredSpeciesLabel");
    }

    protected void createFilteredSpeciesList() {
        $objectMap.put("filteredSpeciesList", filteredSpeciesList = new JList());
        
        filteredSpeciesList.setName("filteredSpeciesList");
        filteredSpeciesList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__filteredSpeciesList"));
        filteredSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__filteredSpeciesList"));
    }

    protected void createFilteredSpeciesListModel() {
        $objectMap.put("filteredSpeciesListModel", filteredSpeciesListModel = new SpeciesListModel());
        
        filteredSpeciesListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__filteredSpeciesListModel"));
    }

    protected void createFilteredSpeciesListSelectionModel() {
        $objectMap.put("filteredSpeciesListSelectionModel", filteredSpeciesListSelectionModel = filteredSpeciesList.getSelectionModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createMatrixPanelEditor() {
        $objectMap.put("matrixPanelEditor", matrixPanelEditor = new MatrixPanelEditor());
        
        matrixPanelEditor.setName("matrixPanelEditor");
    }

    protected void createSaveSelectionButton() {
        $objectMap.put("saveSelectionButton", saveSelectionButton = new JButton());
        
        saveSelectionButton.setName("saveSelectionButton");
        saveSelectionButton.setText(_("coser.ui.selection.details.saveSelection"));
        saveSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveSelectionButton"));
    }

    protected void createSelectedSpeciesLabel() {
        $objectMap.put("selectedSpeciesLabel", selectedSpeciesLabel = new JLabel());
        
        selectedSpeciesLabel.setName("selectedSpeciesLabel");
    }

    protected void createSelectedSpeciesList() {
        $objectMap.put("selectedSpeciesList", selectedSpeciesList = new JList());
        
        selectedSpeciesList.setName("selectedSpeciesList");
        selectedSpeciesList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__selectedSpeciesList"));
        selectedSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedSpeciesList"));
    }

    protected void createSelectedSpeciesListModel() {
        $objectMap.put("selectedSpeciesListModel", selectedSpeciesListModel = new SpeciesListModel());
        
        selectedSpeciesListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectedSpeciesListModel"));
    }

    protected void createSelectedSpeciesListSelectionModel() {
        $objectMap.put("selectedSpeciesListSelectionModel", selectedSpeciesListSelectionModel = selectedSpeciesList.getSelectionModel());
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    protected void createSpeciesGraphPanel() {
        $objectMap.put("speciesGraphPanel", speciesGraphPanel = new JPanel());
        
        speciesGraphPanel.setName("speciesGraphPanel");
        speciesGraphPanel.setLayout(new GridBagLayout());
    }

    protected void createSpeciesValidated() {
        $objectMap.put("speciesValidated", speciesValidated = false);
    }

    protected void createStataMapInfo() {
        $objectMap.put("stataMapInfo", stataMapInfo = new InformationDelegator());
        
        stataMapInfo.setName("stataMapInfo");
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
    }

    protected void createStrataList() {
        $objectMap.put("strataList", strataList = new JList());
        
        strataList.setName("strataList");
        strataList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__strataList"));
        strataList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__strataList"));
    }

    protected void createStrataListModel() {
        $objectMap.put("strataListModel", strataListModel = new StrataListModel());
        
        strataListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__strataListModel"));
    }

    protected void createStrataMap() {
        $objectMap.put("strataMap", strataMap = new CoserMap());
        
        strataMap.setName("strataMap");
    }

    protected void createStrataValidated() {
        $objectMap.put("strataValidated", strataValidated = false);
    }

    protected void createTypeSpeciesLabel() {
        $objectMap.put("typeSpeciesLabel", typeSpeciesLabel = new JLabel());
        
        typeSpeciesLabel.setName("typeSpeciesLabel");
    }

    protected void createTypeSpeciesList() {
        $objectMap.put("typeSpeciesList", typeSpeciesList = new JList());
        
        typeSpeciesList.setName("typeSpeciesList");
        typeSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__typeSpeciesList"));
    }

    protected void createTypeSpeciesModel() {
        $objectMap.put("typeSpeciesModel", typeSpeciesModel = new SpeciesTypesListModel(this));
        
        typeSpeciesModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__typeSpeciesModel"));
    }

    protected void createValidDatesButton() {
        $objectMap.put("validDatesButton", validDatesButton = new JButton());
        
        validDatesButton.setName("validDatesButton");
        validDatesButton.setText(_("coser.ui.selection.details.validYears"));
        validDatesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validDatesButton"));
    }

    protected void createValidFilterButton() {
        $objectMap.put("validFilterButton", validFilterButton = new JButton());
        
        validFilterButton.setName("validFilterButton");
        validFilterButton.setEnabled(false);
        validFilterButton.setText(_("coser.ui.selection.details.validFilter"));
        validFilterButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validFilterButton"));
    }

    protected void createValidSpeciesButton() {
        $objectMap.put("validSpeciesButton", validSpeciesButton = new JButton());
        
        validSpeciesButton.setName("validSpeciesButton");
        validSpeciesButton.setText(_("coser.ui.selection.details.validSpecies"));
        validSpeciesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSpeciesButton"));
    }

    protected void createValidStrataButton() {
        $objectMap.put("validStrataButton", validStrataButton = new JButton());
        
        validStrataButton.setName("validStrataButton");
        validStrataButton.setText(_("coser.ui.selection.details.validStrata"));
        validStrataButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validStrataButton"));
    }

    protected void createValidatorSelection() {
        $objectMap.put("validatorSelection", validatorSelection = SwingValidator.newValidator(Selection.class, null));
    }

    protected void createYearsList() {
        $objectMap.put("yearsList", yearsList = new JList());
        
        yearsList.setName("yearsList");
        yearsList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__yearsList"));
        yearsList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__yearsList"));
    }

    protected void createYearsListModel() {
        $objectMap.put("yearsListModel", yearsListModel = new YearListModel());
    }

    protected void createYearsListSelectionModel() {
        $objectMap.put("yearsListSelectionModel", yearsListSelectionModel = yearsList.getSelectionModel());
    }

    protected void createYearsValidated() {
        $objectMap.put("yearsValidated", yearsValidated = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JSplitPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorSelection();
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JButton1);
        $JToolBar0.add($Component0);
        $JToolBar0.add(saveSelectionButton);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add(detailAccordionPane, JSplitPane.LEFT);
        $JSplitPane0.add(detailDecisionPanel, JSplitPane.RIGHT);
        addChildrenToDetailAccordionPane();
        // inline complete setup of $AccordionPaneSubPanel0
        $AccordionPaneSubPanel0.add($Table1);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(detailsSelectionNameField), new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(detailsDescriptionSP), new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(detailsCommentSP, new GridBagConstraints(1, 2, 3, 1, 0.0, 1.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDetailsDescriptionSP();
        addChildrenToDetailsCommentSP();
        // inline complete setup of $AccordionPaneSubPanel1
        $AccordionPaneSubPanel1.add($Table2);
        // inline complete setup of $Table2
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(validDatesButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(yearsList);
        // inline complete setup of $AccordionPaneSubPanel2
        $AccordionPaneSubPanel2.add($Table3);
        // inline complete setup of $Table3
        $Table3.add(strataLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 2, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(validStrataButton, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(strataList);
        // inline complete setup of $AccordionPaneSubPanel3
        $AccordionPaneSubPanel3.add($Table4);
        // inline complete setup of $Table4
        $Table4.add(typeSpeciesLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane2, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(validFilterButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($Table5, new GridBagConstraints(0, 2, 4, 1, 0.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(validSpeciesButton, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(typeSpeciesList);
        // inline complete setup of $Table5
        $Table5.add(filteredSpeciesLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(selectedSpeciesLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JScrollPane3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($Table6, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 2, 2, 2), 0, 0));
        $Table5.add($JScrollPane4, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JLabel4, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(filteredSpeciesList);
        // inline complete setup of $Table6
        $Table6.add($JButton4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table6.add($JButton5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table6.add($JSeparator0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JButton6, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table6.add($JButton7, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table6.add($JButton8, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table6.add($JButton9, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(selectedSpeciesList);
        addChildrenToDetailDecisionPanel();
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add($Table7);
        // inline complete setup of $Table7
        $Table7.add($JLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(matrixPanelEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(strataMap, BorderLayout.CENTER);
        $JPanel0.add(stataMapInfo, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(speciesGraphPanel);
        
        // apply 20 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 24 property setters
        $JButton0.setIcon(SwingUtil.createImageIcon("report.png"));
        $JButton1.setIcon(SwingUtil.createImageIcon("arrow_rotate_clockwise.png"));
        saveSelectionButton.setIcon(SwingUtil.createImageIcon("disk.png"));
        detailAccordionPane.setMinimumSize(new Dimension(100, 0));
        yearsList.setModel(yearsListModel);
        strataLabel.setText(_("coser.ui.selection.details.strata", 0, 0));
        strataList.setModel(strataListModel);
        $JButton2.setIcon(SwingUtil.createImageIcon("map.png"));
        $JButton3.setIcon(SwingUtil.createImageIcon("table.png"));
        typeSpeciesList.setCellRenderer(new SpeciesTypesRenderer());
        typeSpeciesList.setModel(typeSpeciesModel);
        filteredSpeciesLabel.setText(_("coser.ui.selection.details.filteredSpecies", 0, 0));
        selectedSpeciesLabel.setText(_("coser.ui.selection.details.selectedSpecies", 0, 0));
        filteredSpeciesList.setModel(filteredSpeciesListModel);
        $JButton4.setIcon(SwingUtil.createImageIcon("arrow_right.png"));
        $JButton5.setIcon(SwingUtil.createImageIcon("arrow_left.png"));
        $JButton6.setIcon(SwingUtil.createImageIcon("stock_select_table.png"));
        $JButton7.setIcon(SwingUtil.createImageIcon("stock_select_clear.png"));
        $JButton8.setIcon(SwingUtil.createImageIcon("chart_curve.png"));
        $JButton9.setIcon(SwingUtil.createImageIcon("arrow_jion_up.png"));
        selectedSpeciesList.setModel(selectedSpeciesListModel);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createCreationState();
        createYearsValidated();
        createStrataValidated();
        createSpeciesValidated();
        createSelection();
        createErrorsTableModel();
        createValidatorSelection();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.selection.selectionreport"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.selection.reloadcontroldata"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $Component0
        $objectMap.put("$Component0", $Component0 = javax.swing.Box.createHorizontalGlue());
        
        $Component0.setName("$Component0");
        createSaveSelectionButton();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        createDetailAccordionPane();
        // inline creation of $AccordionPaneSubPanel0
        $objectMap.put("$AccordionPaneSubPanel0", $AccordionPaneSubPanel0 = new AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel0.setName("$AccordionPaneSubPanel0");
        $AccordionPaneSubPanel0.setTitle(_("coser.ui.selection.detail.mainAccordion"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.selection.details.name"));
        createDetailsSelectionNameField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = detailsSelectionNameField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.selection.details.description"));
        createDetailsDescriptionSP();
        createDetailsDescription();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = detailsDescription.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.selection.details.comment"));
        createDetailsCommentSP();
        createDetailsComment();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = detailsComment.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $AccordionPaneSubPanel1
        $objectMap.put("$AccordionPaneSubPanel1", $AccordionPaneSubPanel1 = new AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel1.setName("$AccordionPaneSubPanel1");
        $AccordionPaneSubPanel1.setTitle(_("coser.ui.selection.detail.yearAccordion"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.selection.details.years"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createYearsListModel();
        createYearsList();
        createYearsListSelectionModel();
        createValidDatesButton();
        // inline creation of $AccordionPaneSubPanel2
        $objectMap.put("$AccordionPaneSubPanel2", $AccordionPaneSubPanel2 = new AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel2.setName("$AccordionPaneSubPanel2");
        $AccordionPaneSubPanel2.setTitle(_("coser.ui.selection.detail.strataAccordion"));
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createStrataLabel();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createStrataListModel();
        createStrataList();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(_("coser.ui.selection.details.showMapTip"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setToolTipText(_("coser.ui.selection.details.showSpeciesTip"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        createValidStrataButton();
        // inline creation of $AccordionPaneSubPanel3
        $objectMap.put("$AccordionPaneSubPanel3", $AccordionPaneSubPanel3 = new AccordionPaneSubPanel());
        
        $AccordionPaneSubPanel3.setName("$AccordionPaneSubPanel3");
        $AccordionPaneSubPanel3.setTitle(_("coser.ui.selection.detail.speciesAccordion"));
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        createTypeSpeciesLabel();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createTypeSpeciesModel();
        createTypeSpeciesList();
        createValidFilterButton();
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        createFilteredSpeciesLabel();
        createSelectedSpeciesLabel();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createFilteredSpeciesListModel();
        createFilteredSpeciesList();
        createFilteredSpeciesListSelectionModel();
        // inline creation of $Table6
        $objectMap.put("$Table6", $Table6 = new Table());
        
        $Table6.setName("$Table6");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setToolTipText(_("coser.ui.selection.details.addToSelectedListTip"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setToolTipText(_("coser.ui.selection.details.removeFromSelectedListTip"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setToolTipText(_("coser.ui.selection.details.selectAllSpeciesTip"));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        // inline creation of $JButton7
        $objectMap.put("$JButton7", $JButton7 = new JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.setToolTipText(_("coser.ui.selection.details.unSelectAllSpeciesTip"));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        // inline creation of $JButton8
        $objectMap.put("$JButton8", $JButton8 = new JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.setToolTipText(_("coser.ui.selection.details.displayDiffCatchLengthGraphTip"));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        // inline creation of $JButton9
        $objectMap.put("$JButton9", $JButton9 = new JButton());
        
        $JButton9.setName("$JButton9");
        $JButton9.setToolTipText(_("coser.ui.selection.details.mergeSpeciesTip"));
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createSelectedSpeciesListModel();
        createSelectedSpeciesList();
        createSelectedSpeciesListSelectionModel();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        if ($JLabel4.getFont() != null) {
            $JLabel4.setFont($JLabel4.getFont().deriveFont($JLabel4.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel4.setText(_("coser.ui.selection.details.speciescontextmenu"));
        createValidSpeciesButton();
        createDetailDecisionPanelLayout();
        createDetailDecisionPanel();
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        // inline creation of $Table7
        $objectMap.put("$Table7", $Table7 = new Table());
        
        $Table7.setName("$Table7");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.selection.details.speciesDataDescription"));
        createMatrixPanelEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createStrataMap();
        createStataMapInfo();
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new JScrollPane());
        
        $JScrollPane6.setName("$JScrollPane6");
        createSpeciesGraphPanel();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 20 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 20 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DETAILS_SELECTION_NAME_FIELD_ENABLED, true ,"creationState") {
        
            @Override
            public void processDataBinding() {
                detailsSelectionNameField.setEnabled(isCreationState());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_SELECTION_NAME_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(detailsSelectionNameField, getSelection().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_DESCRIPTION_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(detailsDescription, getSelection().getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(detailsComment, getSelection().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEARS_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (yearsList != null) {
                    yearsList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (yearsList != null) {
                    yearsList.setSelectionModel(new CoserListSelectionModel(yearsList.getSelectionModel(), yearsListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (yearsList != null) {
                    yearsList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_DATES_BUTTON_ENABLED, true ,"yearsValidated") {
        
            @Override
            public void processDataBinding() {
                validDatesButton.setEnabled(!isYearsValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (strataList != null) {
                    strataList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (strataList != null) {
                    strataList.setSelectionModel(new CoserListSelectionModel(strataList.getSelectionModel(), strataListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (strataList != null) {
                    strataList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_STRATA_BUTTON_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                validStrataButton.setEnabled(isYearsValidated() && !isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TYPE_SPECIES_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (typeSpeciesList != null) {
                    $bindingSources.put("typeSpeciesList.getSelectionModel()", typeSpeciesList.getSelectionModel());
                    typeSpeciesList.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    typeSpeciesList.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_TYPE_SPECIES_LABEL_TEXT));
                }
                if (typeSpeciesList != null) {
                    typeSpeciesList.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (typeSpeciesList != null && typeSpeciesList.getModel() != null && typeSpeciesList.getSelectedIndices() != null) {
                    typeSpeciesLabel.setText(_("coser.ui.selection.details.type", typeSpeciesList.getSelectedIndices().length, typeSpeciesList.getModel().getSize()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (typeSpeciesList != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("typeSpeciesList.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    typeSpeciesList.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_TYPE_SPECIES_LABEL_TEXT));
                }
                if (typeSpeciesList != null) {
                    typeSpeciesList.removePropertyChangeListener("model", this);
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TYPE_SPECIES_LIST_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                typeSpeciesList.setEnabled(isYearsValidated() && isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TYPE_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (typeSpeciesList != null) {
                    typeSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (typeSpeciesList != null) {
                    typeSpeciesList.setSelectionModel(new CoserListSelectionModel(typeSpeciesList.getSelectionModel(), typeSpeciesModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (typeSpeciesList != null) {
                    typeSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FILTERED_SPECIES_LIST_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                filteredSpeciesList.setEnabled(isYearsValidated() && isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTERED_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (filteredSpeciesList != null) {
                    filteredSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filteredSpeciesList != null) {
                    filteredSpeciesList.setSelectionModel(new CoserListSelectionModel(filteredSpeciesList.getSelectionModel(), filteredSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filteredSpeciesList != null) {
                    filteredSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON4_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    $bindingSources.put("getFilteredSpeciesList().getSelectionModel()", getFilteredSpeciesList().getSelectionModel());
                    getFilteredSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    getFilteredSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON4_ENABLED));
                }
                addPropertyChangeListener("yearsValidated", this);
                addPropertyChangeListener("strataValidated", this);
            }
        
            @Override
            public void processDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    $JButton4.setEnabled(getFilteredSpeciesList().getSelectedIndex() != -1 && isYearsValidated() && isStrataValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("getFilteredSpeciesList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    getFilteredSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON4_ENABLED));
                }
                removePropertyChangeListener("yearsValidated", this);
                removePropertyChangeListener("strataValidated", this);
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON5_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getSelectedSpeciesList() != null) {
                    $bindingSources.put("getSelectedSpeciesList().getSelectionModel()", getSelectedSpeciesList().getSelectionModel());
                    getSelectedSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u2"));
                    getSelectedSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON5_ENABLED));
                }
                addPropertyChangeListener("yearsValidated", this);
                addPropertyChangeListener("strataValidated", this);
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSpeciesList() != null) {
                    $JButton5.setEnabled(getSelectedSpeciesList().getSelectedIndex() != -1 && isYearsValidated() && isStrataValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getSelectedSpeciesList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("getSelectedSpeciesList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u2"));
                    }
                    getSelectedSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON5_ENABLED));
                }
                removePropertyChangeListener("yearsValidated", this);
                removePropertyChangeListener("strataValidated", this);
            }
        
            public void $pr$u2(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON8_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("yearsValidated", this);
                addPropertyChangeListener("strataValidated", this);
                if (getSelectedSpeciesList() != null) {
                    $bindingSources.put("getSelectedSpeciesList().getSelectionModel()", getSelectedSpeciesList().getSelectionModel());
                    getSelectedSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u3"));
                    getSelectedSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON8_ENABLED));
                }
                if (getFilteredSpeciesList() != null) {
                    $bindingSources.put(" getFilteredSpeciesList().getSelectionModel()",  getFilteredSpeciesList().getSelectionModel());
                     getFilteredSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u3"));
                    getFilteredSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON8_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSpeciesList() != null && getFilteredSpeciesList() != null) {
                    $JButton8.setEnabled(isYearsValidated() && isStrataValidated() && (getSelectedSpeciesList().getSelectedIndex() != -1 || getFilteredSpeciesList().getSelectedIndex() != -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("yearsValidated", this);
                removePropertyChangeListener("strataValidated", this);
                if (getSelectedSpeciesList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("getSelectedSpeciesList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u3"));
                    }
                    getSelectedSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON8_ENABLED));
                }
                if (getFilteredSpeciesList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove(" getFilteredSpeciesList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u3"));
                    }
                    getFilteredSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON8_ENABLED));
                }
            }
        
            public void $pr$u3(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON9_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    $bindingSources.put("getFilteredSpeciesList().getSelectionModel()", getFilteredSpeciesList().getSelectionModel());
                    getFilteredSpeciesList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u4"));
                    getFilteredSpeciesList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON9_ENABLED));
                }
                addPropertyChangeListener("yearsValidated", this);
                addPropertyChangeListener("strataValidated", this);
            }
        
            @Override
            public void processDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    $JButton9.setEnabled(getFilteredSpeciesList().getSelectedIndex() != -1 && isYearsValidated() && isStrataValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getFilteredSpeciesList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("getFilteredSpeciesList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u4"));
                    }
                    getFilteredSpeciesList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.selection.SelectionDetailsView.this, BINDING_$JBUTTON9_ENABLED));
                }
                removePropertyChangeListener("yearsValidated", this);
                removePropertyChangeListener("strataValidated", this);
            }
        
            public void $pr$u4(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_SPECIES_LIST_ENABLED, true ,"yearsValidated" ,"strataValidated") {
        
            @Override
            public void processDataBinding() {
                selectedSpeciesList.setEnabled(isYearsValidated() && isStrataValidated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.setSelectionModel(new CoserListSelectionModel(selectedSpeciesList.getSelectionModel(), selectedSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALID_SPECIES_BUTTON_ENABLED, true ,"yearsValidated" ,"strataValidated" ,"speciesValidated") {
        
            @Override
            public void processDataBinding() {
                validSpeciesButton.setEnabled(isYearsValidated() && isStrataValidated() && !isSpeciesValidated());
            }
        });
    }

}