/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.freize;

import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.ui.CoserFrame;
import fr.ifremer.coser.ui.SelectionsListMenu;
import fr.ifremer.coser.ui.freize.Freize;
import fr.ifremer.coser.ui.freize.FreizeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FreizeHandler
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog(FreizeHandler.class);
    protected static final Icon OK_ICON = new ImageIcon(FreizeHandler.class.getResource("/icons/button_ok.png"));
    protected static final Icon LOCKED_ICON = new ImageIcon(FreizeHandler.class.getResource("/icons/stock_lock.png"));
    protected static final Icon BAD_ICON = new ImageIcon(FreizeHandler.class.getResource("/icons/agt_action_fail.png"));
    protected static final Color COMPLETE_COLOR = Color.GREEN;
    protected static final Color PENDING_COLOR = Color.YELLOW;
    protected static final Color DISABLED_COLOR = null;
    protected FreizeModel model;
    protected Freize view;

    public FreizeHandler(Freize view) {
        this.view = view;
    }

    public void setModel(FreizeModel model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update freize : " + propertyName));
        }
        if ("project".equals(propertyName)) {
            Project newProject;
            Project oldProject = (Project)evt.getOldValue();
            if (oldProject != null) {
                oldProject.getControl().removePropertyChangeListener((PropertyChangeListener)this);
            }
            if ((newProject = (Project)evt.getNewValue()) != null) {
                newProject.getControl().addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.updateUi();
        } else if ("selection".equals(propertyName)) {
            Selection newSelection;
            Selection oldSelection = (Selection)evt.getOldValue();
            if (oldSelection != null) {
                oldSelection.removePropertyChangeListener((PropertyChangeListener)this);
            }
            if ((newSelection = (Selection)evt.getNewValue()) != null) {
                newSelection.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.updateUi();
        } else if ("rsufiResults".equals(propertyName)) {
            this.updateUi();
        } else if ("validated".equals(propertyName) || "validated".equals(propertyName)) {
            this.updateUi();
        }
    }

    protected void updateUi() {
        this.model.setStep1Enabled(false);
        this.model.setStep2Enabled(false);
        this.model.setStep3Enabled(false);
        this.view.getStep0Panel().setBackground(DISABLED_COLOR);
        this.view.getStep1Panel().setBackground(DISABLED_COLOR);
        this.view.getStep2Panel().setBackground(DISABLED_COLOR);
        this.view.getStep3Panel().setBackground(DISABLED_COLOR);
        this.view.getStep4Panel().setBackground(DISABLED_COLOR);
        Project project = this.model.getProject();
        if (project != null) {
            this.view.getStep0Panel().setBackground(COMPLETE_COLOR);
            this.model.setStep1Enabled(true);
            if (project.getControl().isValidated()) {
                this.view.getStep1Panel().setBackground(COMPLETE_COLOR);
                this.model.setStep2Enabled(true);
                if (!project.getSelections().isEmpty()) {
                    this.view.getControlStatus().setText(I18n._((String)"coser.ui.freize.locked", (Object[])new Object[0]));
                    this.view.getControlStatus().setToolTipText(I18n._((String)"coser.ui.freize.controllockedtip", (Object[])new Object[0]));
                    this.view.getControlStatus().setIcon(LOCKED_ICON);
                } else {
                    this.view.getControlStatus().setText(I18n._((String)"coser.ui.freize.validated", (Object[])new Object[0]));
                    this.view.getControlStatus().setIcon(OK_ICON);
                }
                Selection selection = this.model.getSelection();
                if (selection != null && selection.isValidated()) {
                    this.view.getSelectionStatus().setIcon(OK_ICON);
                    this.view.getSelectionStatus().setText(I18n._((String)"coser.ui.freize.validated", (Object[])new Object[0]));
                    this.view.getStep2Panel().setBackground(COMPLETE_COLOR);
                    this.model.setStep3Enabled(true);
                    this.view.getStep3Panel().setBackground(COMPLETE_COLOR);
                    if (selection.getRsufiResults().isEmpty()) {
                        this.view.getStep4Panel().setBackground(PENDING_COLOR);
                    } else {
                        this.view.getStep4Panel().setBackground(COMPLETE_COLOR);
                    }
                } else {
                    this.view.getStep2Panel().setBackground(PENDING_COLOR);
                    this.view.getSelectionStatus().setIcon(BAD_ICON);
                    this.view.getSelectionStatus().setText(I18n._((String)"coser.ui.freize.unvalidated", (Object[])new Object[0]));
                }
            } else {
                this.view.getStep1Panel().setBackground(PENDING_COLOR);
                this.view.getControlStatus().setIcon(BAD_ICON);
                this.view.getControlStatus().setText(I18n._((String)"coser.ui.freize.unvalidated", (Object[])new Object[0]));
            }
        } else {
            this.view.getStep0Panel().setBackground(PENDING_COLOR);
        }
    }

    public void showSelectionDropDownMenu(Freize view, MouseEvent event) {
        JPopupMenu menu = new JPopupMenu();
        SelectionsListMenu oldMenu = new SelectionsListMenu(view.getParentContainer(CoserFrame.class));
        oldMenu.setProject(view.getModel().getProject());
        for (int i = oldMenu.getItemCount() - 1; i >= 0; --i) {
            menu.insert(oldMenu.getMenuComponent(i), 0);
        }
        menu.show((Component)event.getSource(), event.getX(), event.getY());
    }
}

