/*
 * #%L
 * Coser :: UI
 * 
 * $Id: SpeciesListOccDensRenderer.java 1036 2012-08-10 16:10:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.1/coser-ui/src/main/java/fr/ifremer/coser/ui/selection/SpeciesListOccDensRenderer.java $
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.selection;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.util.Map;

import javax.swing.JList;

import org.jdesktop.swingx.renderer.DefaultListRenderer;

import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.ui.selection.model.OccurrenceDensitySpeciesListModel;

/**
 * Specy renderer with occurrence and density display.
 * 
 * @author chatellier
 * @version $Revision: 1036 $
 * 
 * Last update : $Date: 2012-08-10 18:10:16 +0200 (Fri, 10 Aug 2012) $
 * By : $Author: echatellier $
 */
public class SpeciesListOccDensRenderer extends DefaultListRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5404111064519251687L;

    protected Map<String, String> reftaxSpecies;

    public SpeciesListOccDensRenderer(Map<String, String> reftaxSpecies) {
        this.reftaxSpecies = reftaxSpecies;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        String species = (String)value;
        OccurrenceDensitySpeciesListModel model = (OccurrenceDensitySpeciesListModel)list.getModel();

        double occurrence = model.getOccurrence(species);
        double density = model.getDensity(species);

        String speciesText = (String)species;
        if (reftaxSpecies.containsKey(species)) {
            speciesText = reftaxSpecies.get(species);
        }
        String stringValue = _("coser.ui.selection.occurrencedensityrenderer", speciesText, occurrence, density);
        
        return super.getListCellRendererComponent(list, stringValue, index, isSelected, cellHasFocus);
    }
    
}
