/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.common;

import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.Selection;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixFilter;

public class LengthStructureMatrixFilter
implements MatrixFilter {
    protected Project project;
    protected AbstractDataContainer container;

    public LengthStructureMatrixFilter(Project project, AbstractDataContainer container) {
        this.project = project;
        this.container = container;
    }

    public MatrixND filter(MatrixND matrix) {
        String title = "Coser: " + this.project.getName();
        if (this.container instanceof Selection) {
            title = title + ": " + ((Selection)this.container).getName();
        }
        matrix.setName(title);
        MatrixND filteredMatrix = matrix;
        String semantic0Name = matrix.getDimensionName(0);
        if ("coser.business.common.length".equals(semantic0Name)) {
            List semantic0 = matrix.getSemantic(0);
            double first = Double.MAX_VALUE;
            double last = Double.MIN_VALUE;
            boolean atLeastOneAdujments = false;
            for (Object categorySem : matrix.getSemantic(0)) {
                for (Object serieSem : matrix.getSemantic(1)) {
                    Object[] objectArray = new Object[]{categorySem, serieSem};
                    Double value = matrix.getValue(objectArray);
                    if (!(value > 0.0)) continue;
                    double category = (Double)categorySem;
                    if (first > category) {
                        first = category;
                    }
                    if (last < category) {
                        last = category;
                    }
                    atLeastOneAdujments = true;
                }
            }
            if (!atLeastOneAdujments) {
                first = (Double)matrix.getSemantic(0).get(0);
                last = (Double)matrix.getSemantic(0).get(matrix.getSemantic(0).size() - 1);
            }
            boolean haltStep = false;
            for (Object number : semantic0) {
                double dNumber = (Double)number;
                if (!(dNumber - Math.floor(dNumber) > 0.0)) continue;
                haltStep = true;
                break;
            }
            ArrayList<Double> newLengthSemantic = new ArrayList<Double>();
            for (double index = first; index <= last; index += haltStep ? 0.5 : 1.0) {
                newLengthSemantic.add(index);
            }
            List[] semantics = new List[matrix.getSemantics().length];
            semantics[0] = newLengthSemantic;
            System.arraycopy(matrix.getSemantics(), 1, semantics, 1, matrix.getSemantics().length - 1);
            filteredMatrix = MatrixFactory.getInstance().create(matrix.getName(), semantics);
            filteredMatrix.pasteSemantics(matrix);
        }
        return filteredMatrix;
    }

    public MatrixND filterDimension(MatrixND matrix, int dim, int sumStep) {
        return matrix;
    }
}

