package fr.ifremer.coser.ui.result;
/*
 * #%L
 * Coser :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class SelectUploadResultView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS09TQRQeKgWKDx4FhfgIaI3G6C2guMGggiJi8UHVELtx2jvQgem948xcuW6MP8GfoHs3Ju5cGReuXbgx/gVjXLg1npnb9vaWa2lSFtNyzvm+85jTb979REkp0OQW9n1LeI6iFWKtXF9fv1fcIiV1g8iSoFy5AgV/XQmUKKD9dt0uFTpVyGl4tgrPLroV7jrEaUDP5VC/VC8YkWVClELHo4iSlNl83T3nc0/UWOtFxbG++f0r8dp+9TaBkM+huiPQysReqLCT7hxKUFuhYcj0HGcZdjahDEGdTaj3oLYtMizlXVwhz9BL1JtDPRwLIFPoZPstGw6D97lCvZmHuMjIlELTG8KiG4JUiLBKroTTo5Yg0mPKyhMG03/EmYvtNWN6TMkO54anB1jK2LEZEQqdbcESIJeD0BDcl1nJ4SJhUMOwbtK35A70bAVWHZTaFTut/x+K+qqtTCs0Fpl5wGZ88WQzdbKRum9ggzJFxALZpM4NrIhCE67YtLZg07aVywNS31pZ1877tLRNRJSgRn4xhvxgQH7TsTVaG4/Ggy/FgAe5V2RUdxPMEzZ+NDK2xTIpbS+4flPOzEq+JFzG7mNHX/eRCCZ0RUc0DkGUhcnMFFddmzCFplpdtfQ2aDMkvPKRONrm66/f2OkQl8lRqYJtpK5jWKGXE4243RFh3gFsV/d3wVPKdRRKR1IG1vgtmY1ZuchQzU6eiQaMSVMJsZtnof3nwsLSMXHadUEfl1v2b9JOhVTDcCPuc9LYpvZcjBaWylSbnWp0CnQ08tMBIbRCIQyVqquAksIDM3RY2K2da+AKVHOsSTU1ofH+PZz+9vHHh6WaVB6C3KOxoQ1KDxLGhctBZ6hOPRDopKcoy65iPldAqWCM5hk4FlNYvuqG4iDfkIZbGm4tY1kGimTv90+fDz/9ug8lllC/VrslrONvo5Qqw2qXXWb7/Oo1U9GBnT44B3VtCnUr4oMOD1+hDqMOmcAKhLvoKTLvwxiOxYyhXksx9eVPOv/+Wm0UXVDa+H/Dw3Ekn6CeIJt5N6pPQuw7sZ9L4tluKP1xj0GX/hzk1U26Zc47u3vV5lV93PU9/XHPlKy/PTC+dMcMYx0zHO+YYXJPBlCG2o+2Bc+pNniSlUBQD12xscITRerYoEbz8YTn2yDsJY4WkFZ1zXQ8oc4ZZtti2NLHdjzDXFsMvEUNVzvuonOG68DwD3Q7yl35CgAA";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    public static final String PROPERTY$LIST_SELECTION_MODEL1 = "$ListSelectionModel1";
    private static final Log log = LogFactory.getLog(SelectUploadResultView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addResultButton;
    protected JTable availableResultTable;
    protected RsufiResultTableModel availableResultTableModel;
    protected JXDatePicker filterBeginDate;
    protected JXDatePicker filterEndDate;
    protected ResultHandler handler;
    protected JCheckBox publiableResults;
    protected JButton removeResultButton;
    protected JTable selectedResultTable;
    protected RsufiResultTableModel selectedResultTableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private ListSelectionModel $ListSelectionModel0;
    private ListSelectionModel $ListSelectionModel1;
    private SelectUploadResultView $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectUploadResultView() {
        $initialize();
    }

    public SelectUploadResultView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showExportUploadDialog(this);
    }

    public void doActionPerformed__on__addResultButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addAvailableResult(this);
    }

    public void doActionPerformed__on__filterBeginDate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateAvailableResultsFilter(this);
    }

    public void doActionPerformed__on__filterEndDate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateAvailableResultsFilter(this);
    }

    public void doActionPerformed__on__publiableResults(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateAvailableResultsFilter(this);
    }

    public void doActionPerformed__on__removeResultButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeSelectedResult(this);
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addResultButton.setEnabled(getAvailableResultTable().getSelectedRow() != -1);
    }

    public void doValueChanged__on__$ListSelectionModel1(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeResultButton.setEnabled(getSelectedResultTable().getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddResultButton() {
        return addResultButton;
    }

    public JTable getAvailableResultTable() {
        return availableResultTable;
    }

    public RsufiResultTableModel getAvailableResultTableModel() {
        return availableResultTableModel;
    }

    public JXDatePicker getFilterBeginDate() {
        return filterBeginDate;
    }

    public JXDatePicker getFilterEndDate() {
        return filterEndDate;
    }

    public ResultHandler getHandler() {
        return handler;
    }

    public JCheckBox getPubliableResults() {
        return publiableResults;
    }

    public JButton getRemoveResultButton() {
        return removeResultButton;
    }

    public JTable getSelectedResultTable() {
        return selectedResultTable;
    }

    public RsufiResultTableModel getSelectedResultTableModel() {
        return selectedResultTableModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void set$ListSelectionModel1(ListSelectionModel $ListSelectionModel1) {
        ListSelectionModel oldValue = this.$ListSelectionModel1;
        this.$ListSelectionModel1 = $ListSelectionModel1;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL1, oldValue, $ListSelectionModel1);
    }

    public void setHandler(ResultHandler handler) {
        ResultHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected ListSelectionModel get$ListSelectionModel1() {
        return $ListSelectionModel1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddResultButton() {
        $objectMap.put("addResultButton", addResultButton = new JButton());
        
        addResultButton.setName("addResultButton");
        addResultButton.setEnabled(false);
        addResultButton.setText(_("coser.ui.uploadresult.addResults"));
        addResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addResultButton"));
    }

    protected void createAvailableResultTable() {
        $objectMap.put("availableResultTable", availableResultTable = new JTable());
        
        availableResultTable.setName("availableResultTable");
    }

    protected void createAvailableResultTableModel() {
        $objectMap.put("availableResultTableModel", availableResultTableModel = new RsufiResultTableModel(false));
    }

    protected void createFilterBeginDate() {
        $objectMap.put("filterBeginDate", filterBeginDate = new JXDatePicker());
        
        filterBeginDate.setName("filterBeginDate");
        filterBeginDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBeginDate"));
    }

    protected void createFilterEndDate() {
        $objectMap.put("filterEndDate", filterEndDate = new JXDatePicker());
        
        filterEndDate.setName("filterEndDate");
        filterEndDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterEndDate"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createPubliableResults() {
        $objectMap.put("publiableResults", publiableResults = new JCheckBox());
        
        publiableResults.setName("publiableResults");
        publiableResults.setSelected(true);
        publiableResults.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__publiableResults"));
    }

    protected void createRemoveResultButton() {
        $objectMap.put("removeResultButton", removeResultButton = new JButton());
        
        removeResultButton.setName("removeResultButton");
        removeResultButton.setEnabled(false);
        removeResultButton.setText(_("coser.ui.uploadresult.removeResults"));
        removeResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeResultButton"));
    }

    protected void createSelectedResultTable() {
        $objectMap.put("selectedResultTable", selectedResultTable = new JTable());
        
        selectedResultTable.setName("selectedResultTable");
    }

    protected void createSelectedResultTableModel() {
        $objectMap.put("selectedResultTableModel", selectedResultTableModel = new RsufiResultTableModel(true));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addResultButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(removeResultButton, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(filterBeginDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(filterEndDate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(publiableResults, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(availableResultTable);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(selectedResultTable);
        
        // apply 2 property setters
        availableResultTable.setModel(getAvailableResultTableModel());
        selectedResultTable.setModel(getSelectedResultTableModel());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.uploadresult.explanation"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.uploadresult.availableResults"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.uploadresult.filter.beginDate"));
        createFilterBeginDate();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.uploadresult.filter.endDate"));
        createFilterEndDate();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.uploadresult.filter.publiableResults"));
        createPubliableResults();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAvailableResultTableModel();
        createAvailableResultTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = availableResultTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createAddResultButton();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.uploadresult.selectedResults"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSelectedResultTableModel();
        createSelectedResultTable();
        // inline creation of $ListSelectionModel1
        $objectMap.put("$ListSelectionModel1", $ListSelectionModel1 = selectedResultTable.getSelectionModel());
        
        $ListSelectionModel1.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel1"));
        createRemoveResultButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.uploadresult.exportupload"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}