/*
 * #%L
 * 
 * 
 * $Id: OtherDataFileListModel.java 1042 2012-08-14 09:26:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.3/coser-ui/src/main/java/fr/ifremer/coser/ui/result/OtherDataFileListModel.java $
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.result;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractListModel;

/**
 * Modele de list pour la list des fichiers et répertoire des fichiers
 * additionnels.
 * 
 * @author chatellier
 * @version $Revision: 1042 $
 * 
 * Last update : $Date: 2012-08-14 11:26:57 +0200 (mar. 14 août 2012) $
 * By : $Author: echatellier $
 */
public class OtherDataFileListModel extends AbstractListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8652851018076968539L;

    protected List<File> otherFiles;

    public OtherDataFileListModel() {
        otherFiles = new ArrayList<File>();
    }

    public List<File> getOtherFiles() {
        return otherFiles;
    }
    
    public void setOtherFiles(List<File> otherFiles) {
        this.otherFiles = otherFiles;
        fireContentsChanged(this, 0, otherFiles.size() - 1);
    }

    public void add(File file) {
        otherFiles.add(file);
        fireIntervalAdded(this, otherFiles.size() - 1, otherFiles.size() - 1);
    }

    public void remove(File file) {
        int index = otherFiles.indexOf(file);
        if (otherFiles.remove(file)) {
            fireIntervalRemoved(this, index, index);
        }
    }

    @Override
    public int getSize() {
        return otherFiles.size();
    }

    @Override
    public Object getElementAt(int index) {
        return otherFiles.get(index);
    }
}
