package fr.ifremer.coser.ui.freize;
/*
 * #%L
 * Coser :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.ui.CoserFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class Freize extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONTROL_STATUS_ENABLED = "controlStatus.enabled";
    public static final String BINDING_HANDLER_MODEL = "handler.model";
    public static final String BINDING_SELECTION_STATUS_ENABLED = "selectionStatus.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";
    private static final String BINDING_$JBUTTON5_ENABLED = "$JButton5.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQU8TQRSeVgoURLAVBAVTEAgxsoUWjQkEEbRBUtRYD4RemHYHumS7u8zOyuLB+BP8CXr3YuLNk/Hg2YMX418wxoNX48xs2aV0mU7cHmbb9973ve+96Xv77idI2BiM70PXVbBjEK2OlI17W1uPK/uoSu4ju4o1i5gYeJ9YHMTLoFf17TYB18tFBs824Nk1s26ZBjJOoBeLoMcmRzqyawgRAsaaEVXbzpZ896JrOfiY1RcVxvrm96/4a/XV2zgArkXVDdJSMu1QQSUdRRDXVAJSNNNzmNWhsUdlYM3Yo3r7mG1Nh7b9CNbRAXgJuoqg04KYkhEwIV8y5+B41yKge3LjCTSQPkfA+C5WtF2M6ggrVdOmp6Mp9Lf2AikF/rAsDuwkIFE3VaQTMN0Ws8kCA2BXDRqqjjABM22h615oAKYFIGuO6yVguKmx9iFtk/IMVnTem6SPoQUWYYUXmGItdBuhnpUFpfzY5OTGqkOIadDgdFOwZz4jep4ZrjQ7udR5LpVZLoWL4sjL7Bhrpc35tIGzr2oaBJt6iUDi2CFonjfXLm/OR0615s37eQNnv410On+aaZzKPNWcOd8uc95HzrZmXvAzzzbTLrSjXfBp8620t3xa6sTgatMfh866Esx6MIyxMkhgh5rpP63cuh6eUpe3GIZPLQZGyL1/h9LfPv74UDjeBhM092Bo6IllRqfUwqZFB0Rjqfu9VeAQTc9uQmuxDJLeTfBNNxoirNRwU3E030UGVxhcWYd2jVIkur5/+jy08/UciBdAj25CtQBZ/EOQJDVMu2DqqmvdXeGKzh9203OAaSOgs2JilU3uhSUVEpipaIZKh2PZpU0YDWmCr6SS/PInXXq/ctyIGBU2cmZ40IzENujUDF0zEF+MjZ0Xugh7LRs5qhnstrBtF2PPHquxT5b5uRpaqQ6PTIcw/wPXYY8Cl82+rUuzeDtSQDLQloSZ7wsY0hIyenfpypg9RNpejb4oUkteRzOQ0DdLxSFoOZx6SIK6gyCXd6n8vxzMvCNgGInMMBq5ydckOtGFDPbqUQU0GSkh24JS5BhEzZBjOBBUMRFZgxyDSMNk5CudjqxhJvJtyjGIOinHIKriRmQNcgwiDTcj36YSWcNc5NuUYxB1Uo5BVEUusgY5BtFdLESu4nbku5BjEPVBjkFUxZ3IGhjDP1yfq6oPDwAA";
    private static final Log log = LogFactory.getLog(Freize.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel controlStatus;
    protected FreizeHandler handler;
    protected FreizeModel model;
    protected JLabel selectionStatus;
    protected Table step0Panel;
    protected Table step1Panel;
    protected Table step2Panel;
    protected Table step3Panel;
    protected Table step4Panel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private Freize $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public Freize() {
        $initialize();
    }

    public Freize(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public Freize(boolean param0) {
        super(param0);
        $initialize();
    }

    public Freize(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public Freize(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public Freize(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public Freize(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public Freize(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(CoserFrame.class).getHandler().showProjectCreationView();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(CoserFrame.class).getHandler().showProjectOpenView();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(CoserFrame.class).getHandler().showControlView();
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(CoserFrame.class).getHandler().showSelectionView(model.getSelection(), 2);
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(CoserFrame.class).getHandler().showSelectionView(model.getSelection(), 2);
    }

    public void doMousePressed__on__$JButton3(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectionDropDownMenu(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getControlStatus() {
        return controlStatus;
    }

    public FreizeHandler getHandler() {
        return handler;
    }

    public FreizeModel getModel() {
        return model;
    }

    public JLabel getSelectionStatus() {
        return selectionStatus;
    }

    public Table getStep0Panel() {
        return step0Panel;
    }

    public Table getStep1Panel() {
        return step1Panel;
    }

    public Table getStep2Panel() {
        return step2Panel;
    }

    public Table getStep3Panel() {
        return step3Panel;
    }

    public Table getStep4Panel() {
        return step4Panel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(FreizeModel model) {
        FreizeModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToStep0Panel() {
        if (!allComponentsCreated) {
            return;
        }
        step0Panel.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step0Panel.add($JButton0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step0Panel.add($JButton1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToStep1Panel() {
        if (!allComponentsCreated) {
            return;
        }
        step1Panel.add($JLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step1Panel.add($JButton2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step1Panel.add(controlStatus, new GridBagConstraints(1, 1, 1, 1, 2.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToStep2Panel() {
        if (!allComponentsCreated) {
            return;
        }
        step2Panel.add($JLabel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step2Panel.add($JButton3, new GridBagConstraints(0, 1, 1, 1, 2.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step2Panel.add(selectionStatus, new GridBagConstraints(1, 1, 1, 1, 2.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToStep3Panel() {
        if (!allComponentsCreated) {
            return;
        }
        step3Panel.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step3Panel.add($JButton4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToStep4Panel() {
        if (!allComponentsCreated) {
            return;
        }
        step4Panel.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        step4Panel.add($JButton5, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createControlStatus() {
        $objectMap.put("controlStatus", controlStatus = new JLabel());
        
        controlStatus.setName("controlStatus");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FreizeHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = new FreizeModel());
    }

    protected void createSelectionStatus() {
        $objectMap.put("selectionStatus", selectionStatus = new JLabel());
        
        selectionStatus.setName("selectionStatus");
    }

    protected void createStep0Panel() {
        $objectMap.put("step0Panel", step0Panel = new Table());
        
        step0Panel.setName("step0Panel");
    }

    protected void createStep1Panel() {
        $objectMap.put("step1Panel", step1Panel = new Table());
        
        step1Panel.setName("step1Panel");
    }

    protected void createStep2Panel() {
        $objectMap.put("step2Panel", step2Panel = new Table());
        
        step2Panel.setName("step2Panel");
    }

    protected void createStep3Panel() {
        $objectMap.put("step3Panel", step3Panel = new Table());
        
        step3Panel.setName("step3Panel");
    }

    protected void createStep4Panel() {
        $objectMap.put("step4Panel", step4Panel = new Table());
        
        step4Panel.setName("step4Panel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(step0Panel);
        add(SwingUtil.boxComponentWithJxLayer(step1Panel));
        add(SwingUtil.boxComponentWithJxLayer(step2Panel));
        add(SwingUtil.boxComponentWithJxLayer(step3Panel));
        add(SwingUtil.boxComponentWithJxLayer(step4Panel));
        addChildrenToStep0Panel();
        addChildrenToStep1Panel();
        addChildrenToStep2Panel();
        addChildrenToStep3Panel();
        addChildrenToStep4Panel();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setBorder(BorderFactory.createLineBorder(Color.BLACK));
        step0Panel.setBorder(BorderFactory.createEtchedBorder());
        step1Panel.setBorder(BorderFactory.createEtchedBorder());
        step2Panel.setBorder(BorderFactory.createEtchedBorder());
        step3Panel.setBorder(BorderFactory.createEtchedBorder());
        step4Panel.setBorder(BorderFactory.createEtchedBorder());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHandler();
        createStep0Panel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
        $JLabel0.setText(_("coser.ui.freize.projectstep"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.freize.projectcreate"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.freize.projectopen"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createStep1Panel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        if ($JLabel1.getFont() != null) {
            $JLabel1.setFont($JLabel1.getFont().deriveFont($JLabel1.getFont().getStyle() | Font.BOLD));
        }
        $JLabel1.setText(_("coser.ui.freize.controlstep"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("coser.ui.freize.controlaction"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        createControlStatus();
        createStep2Panel();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        if ($JLabel2.getFont() != null) {
            $JLabel2.setFont($JLabel2.getFont().deriveFont($JLabel2.getFont().getStyle() | Font.BOLD));
        }
        $JLabel2.setText(_("coser.ui.freize.selectionstep"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("coser.ui.freize.selectionaction"));
        $JButton3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mousePressed", this, "doMousePressed__on__$JButton3"));
        createSelectionStatus();
        createStep3Panel();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        if ($JLabel3.getFont() != null) {
            $JLabel3.setFont($JLabel3.getFont().deriveFont($JLabel3.getFont().getStyle() | Font.BOLD));
        }
        $JLabel3.setText(_("coser.ui.freize.rsufistep"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("coser.ui.freize.rsufiaction"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        createStep4Panel();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        if ($JLabel4.getFont() != null) {
            $JLabel4.setFont($JLabel4.getFont().deriveFont($JLabel4.getFont().getStyle() | Font.BOLD));
        }
        $JLabel4.setText(_("coser.ui.freize.resultstep"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("coser.ui.freize.resultaction"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new GridLayout(0, 5));
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HANDLER_MODEL, true ,"model") {
        
            @Override
            public void processDataBinding() {
                handler.setModel(getModel());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step1Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JLabel1.setEnabled(model.isStep1Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step1Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step1Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JButton2.setEnabled(model.isStep1Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step1Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_STATUS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step1Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    controlStatus.setEnabled(model.isStep1Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step1Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step2Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JLabel2.setEnabled(model.isStep2Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step2Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON3_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step2Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JButton3.setEnabled(model.isStep2Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step2Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_STATUS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step2Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectionStatus.setEnabled(model.isStep2Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step2Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL3_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step3Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JLabel3.setEnabled(model.isStep3Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step3Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON4_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step3Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JButton4.setEnabled(model.isStep3Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step3Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL4_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step3Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JLabel4.setEnabled(model.isStep3Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step3Enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON5_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step3Enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JButton5.setEnabled(model.isStep3Enabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step3Enabled", this);
                }
            }
        });
    }

}