/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.selection;

import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.ui.selection.model.MaturitySpeciesListModel;
import fr.ifremer.coser.ui.selection.model.OccurrenceDensitySpeciesListModel;
import fr.ifremer.coser.ui.selection.model.SizeAllYearSpeciesListModel;
import fr.ifremer.coser.ui.selection.model.SpeciesListModel;
import fr.ifremer.coser.ui.util.CoserListSelectionModel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledSeparator;
import static org.nuiton.i18n.I18n._;

public class SelectionListsView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTION = "selection";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ALL_SPECIES_COMMENT_FIELD_TEXT = "allSpeciesCommentField.text";
    public static final String BINDING_MATURITY_COMMENT_FIELD_TEXT = "maturityCommentField.text";
    public static final String BINDING_OCCURRENCE_DENSITY_COMMENT_FIELD_TEXT = "occurrenceDensityCommentField.text";
    public static final String BINDING_SELECTION_ALL_SPECIES_LIST_SELECTION_MODEL = "selectionAllSpeciesList.selectionModel";
    public static final String BINDING_SELECTION_FILTER_DENSITY_FIELD_TEXT = "selectionFilterDensityField.text";
    public static final String BINDING_SELECTION_FILTER_OCCURRENCE_FIELD_TEXT = "selectionFilterOccurrenceField.text";
    public static final String BINDING_SELECTION_MATURITY_LIST_SELECTION_MODEL = "selectionMaturityList.selectionModel";
    public static final String BINDING_SELECTION_OCCURRENCE_DENSITY_LIST_SELECTION_MODEL = "selectionOccurrenceDensityList.selectionModel";
    public static final String BINDING_SELECTION_SIZE_ALL_YEAR_LIST_SELECTION_MODEL = "selectionSizeAllYearList.selectionModel";
    public static final String BINDING_SIZE_ALL_YEAR_COMMENT_FIELD_TEXT = "sizeAllYearCommentField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWXz08kRRTHa8YFlh+7q/xGfogLRqNJ8xtWIbKwSHYRRBliWDloTXcBzdZ091ZXw6BGjYmJiYnx5MFEs5voxXgxMfHgyXjw4sWDF+M/4MEYD3o0VvXMdE9P19TUWsqhgX71Pu/76ser11/8Bpp8Ah4+hsWiQQKH2gVkbKzs7W3nj5FJ15BvEtujLgGln0wWZPdBuxW99ykY29/k7hNl94lrbsFzHeRUeS9ugjafnmHkHyFEKRhOepi+P5GLzItFLyAVaiRKRL3zx+/ZD6y37mYBKHpM3SJLZbSRV5zJuU2QtS0KOlmkEziBoXPIZBDbOWR6L/B31zD0/edgAd0Gb4CWTdDsQcJgFFxWTzlkhP5Fj4KW8V2Yx2iSgskDYtgHBBUQMUzXZ8/ANnyE2bTbrmPkKn9t2j71X7TRqeeFmGYGOYKOhRGhwFCEXC85xIjWaBAFD6UgeQSrnGOvtvGNXdfFq5CwBLr5DBUN/5RNmFF5zwe2RuO7fHiCIs5qQCmP15VwLL3lDp2RX/cJxLZV48htfclxlyDGOQ+ZNvI3YR5hCh5xyaFxzPbnLep6pRBFY2Nv16YYMSBbP8gWJ6ly2DXNgLCFNdEacnybnlUz+aChpEOfb7+KVjC+iSBpMLS7AGlAGiPL+2KKgv7EBi5NUmhLOpwf3whZbCE6E/MZRRiLxo5Ei71uY4rIdpTvuo0wOwG9yaVERRoakpS28TXXDApsl7OYA9UelDkYFaOXkjjF/38sCavYpgW2wRq55UWJJD1RT1cYyEgLmBEE6YSeh8/YTHB6KU60wRIyn4eOYJbDt8kVaR0v7+XJCLSYNk4JjBfGN3ImcTHmVBaqLxEqNiXjDUXTtBKfAlYstlyLn4RZeWko8FFGrZtXtcfFdAoeSG439o67rIqzCdNdSwofi9DbtQevSv8zKvpTgPoJjcij8lEb/PGsOJFpQSLDETIXF4SqFJaVliBdS9Li++tFimTviGXPCGQ/GMG2ysWpSvOSiuatmqKWFtwjjBGpvZk+GNPRwRAcqRmZcVZmnJMZ52XGBZnxisz4pMBYqUWzUS1K2+YktnmJbUFgS+yCWcEu6I3vTta+8PJZvgx6UpfBCkGQexUFNXe6puYm4s6JDk3qtq0Ozwe9zh9vCmLNyGLNC2JVX9TCKO8IoszKoiwIokR3vDDEe4IQc5UQBAwmrnvWCRtxJxy3qpl90EQC9pqVgv1087zDTKW2ub+mbebA0Pp3b9dP3/zy1XqlV15gsXuEQ6tafdbDesT1WKdp89CXSo1yQG08sQW9xf1KGxl+BwwJhOXKZiaOxQtvDoO7G9ehf8QQTS0/f/td7ys/3gey66ANu9Bah3z8DdBKjwibBRdbRW/5aqio4/Q8e97PtbHDdsBGU94Xsat5yXaw7aBRSFn7ng8oerrI5mJIMBeRoHzr93925b68WpmPDNM3UHd4PCdNL4HmUrTw64EvZEudr4V2z0eB5cYfAKJPggz/3eWVt9uH4fMjUcLnbJM3zxeXLJb2aN52LHY+WZ7c4ZMwAf7XnZDXq8LjXRu3fvxvGfz1p/zxmZgwoET4XKKhMYGCJsp7e4mMQSUZX0sII9qEUW3CZe3JfFRhMltMFwcFx5dgHlcXUieVeyDU0TCpTZhWIvwgIcxqz8M9EOpouKKypMjhVdKSYJ7SFqJGkBWLZYVU2qnr4l3b25VXrsaoRmJWlAh/STSoEX6VEG6o1L6wHZckogK5GLfq/wGtw0QY7yDHQqT0RV2H9YLKBGVatAkd/6uGPW0NagSZhpe1NSgRpJsValcQNYJMg6mtQZ+AtAmH2gRbm3BLm1DQJrjahNvaBF+bEGgTTlVaeeKeylq217RbFSVC5kCi4W1tDUoEqYZ3tTUoEaQa3tfWwAn/AGDbLxG4GwAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    public static final String PROPERTY$DOCUMENT5 = "$Document5";
    private static final Log log = LogFactory.getLog(SelectionListsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea allSpeciesCommentField;
    protected JXTitledSeparator allSpeciesLabel;
    protected JButton applyOccDensFilter;
    protected SelectionHandler handler;
    protected JTextArea maturityCommentField;
    protected JXTitledSeparator maturitySpeciesLabel;
    protected JTextArea occurrenceDensityCommentField;
    protected JXTitledSeparator occurrenceDensitySpeciesLabel;
    protected JButton saveSelectionButton;
    protected Selection selection;
    protected JList selectionAllSpeciesList;
    protected SpeciesListModel selectionAllSpeciesListModel;
    protected JTextField selectionFilterDensityField;
    protected JTextField selectionFilterOccurrenceField;
    protected JList selectionMaturityList;
    protected MaturitySpeciesListModel selectionMaturityListModel;
    protected JList selectionOccurrenceDensityList;
    protected OccurrenceDensitySpeciesListModel selectionOccurrenceDensityListModel;
    protected JList selectionSizeAllYearList;
    protected SizeAllYearSpeciesListModel selectionSizeAllYearListModel;
    protected JTextArea sizeAllYearCommentField;
    protected JXTitledSeparator sizeAllYearSpeciesLabel;
    protected JButton validSelectionButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectionListsView $Table0 = this;
    private JToolBar $JToolBar0;
    private Table $Table1;
    private JLabel $JLabel0;
    private Document $Document0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private Document $Document1;
    private JLabel $JLabel3;
    private JPanel $JPanel0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private JButton $JButton7;
    private JButton $JButton8;
    private JButton $JButton9;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JScrollPane $JScrollPane4;
    private Document $Document2;
    private JScrollPane $JScrollPane5;
    private Document $Document3;
    private JScrollPane $JScrollPane6;
    private Document $Document4;
    private JScrollPane $JScrollPane7;
    private Document $Document5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // le modele de la liste est alliment? par la selection de la pr?c?dente liste
            // la selection est mise ? jour par la modification du model de la liste
            
            void $afterCompleteSetup() {
                // modification (all species -> all species list)
                selectionAllSpeciesList.addListSelectionListener(selectionOccurrenceDensityListModel);
                selectionOccurrenceDensityListModel.addListDataListener((CoserListSelectionModel)selectionOccurrenceDensityList.getSelectionModel());
                
                selectionOccurrenceDensityList.addListSelectionListener(selectionSizeAllYearListModel);
                selectionSizeAllYearListModel.addListDataListener((CoserListSelectionModel)selectionSizeAllYearList.getSelectionModel());
                
                selectionSizeAllYearList.addListSelectionListener(selectionMaturityListModel);
                selectionMaturityListModel.addListDataListener((CoserListSelectionModel)selectionMaturityList.getSelectionModel());
                
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionListsView() {
        $initialize();
    }

    public SelectionListsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionMaturityList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionMaturityList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionOccurrenceDensityList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionOccurrenceDensityList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionSizeAllYearList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionSizeAllYearList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().displayCompareNumberCatchGraph(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().displayLengthStructureGraph(this);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionAllSpeciesList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ((CoserListSelectionModel)selectionAllSpeciesList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__applyOccDensFilter(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateOccurrenceDensityFilter(this);applyOccDensFilter.setEnabled(false);
    }

    public void doActionPerformed__on__saveSelectionButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveSelection(this);
    }

    public void doActionPerformed__on__validSelectionButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelection(this);
    }

    public void doContentsChanged__on__selectionAllSpeciesListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        allSpeciesLabel.setTitle(_("coser.ui.selection.allSpecies", selectionAllSpeciesList.getSelectedIndices().length, selectionAllSpeciesList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectionMaturityListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        maturitySpeciesLabel.setTitle(_("coser.ui.selection.maturitySpecies", selectionMaturityList.getSelectedIndices().length, selectionMaturityList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectionOccurrenceDensityListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        occurrenceDensitySpeciesLabel.setTitle(_("coser.ui.selection.occurrenceDensitySpecies", selectionOccurrenceDensityList.getSelectedIndices().length, selectionOccurrenceDensityList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectionSizeAllYearListModel(ListDataEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        sizeAllYearSpeciesLabel.setTitle(_("coser.ui.selection.sizeAllYearSpecies", selectionSizeAllYearList.getSelectedIndices().length, selectionSizeAllYearList.getModel().getSize()));
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        applyOccDensFilter.setEnabled(true);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        applyOccDensFilter.setEnabled(true);
    }

    public void doInsertUpdate__on__$Document5(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesMaturityComment(maturityCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document5(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesMaturityComment(maturityCommentField.getText());
    }

    public void doInsertUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesSizeAllYearComment(sizeAllYearCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesSizeAllYearComment(sizeAllYearCommentField.getText());
    }

    public void doInsertUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesOccDensComment(occurrenceDensityCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesOccDensComment(occurrenceDensityCommentField.getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesComment(allSpeciesCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setSelectedSpeciesComment(allSpeciesCommentField.getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        applyOccDensFilter.setEnabled(true);
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        applyOccDensFilter.setEnabled(true);
    }

    public void doValueChanged__on__selectionAllSpeciesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        allSpeciesLabel.setTitle(_("coser.ui.selection.allSpecies", selectionAllSpeciesList.getSelectedIndices().length, selectionAllSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__selectionMaturityList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        maturitySpeciesLabel.setTitle(_("coser.ui.selection.maturitySpecies", selectionMaturityList.getSelectedIndices().length, selectionMaturityList.getModel().getSize()));
    }

    public void doValueChanged__on__selectionOccurrenceDensityList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        applyOccDensFilter.setEnabled(true); occurrenceDensitySpeciesLabel.setTitle(_("coser.ui.selection.occurrenceDensitySpecies", selectionOccurrenceDensityList.getSelectedIndices().length, selectionOccurrenceDensityList.getModel().getSize()));
    }

    public void doValueChanged__on__selectionSizeAllYearList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        sizeAllYearSpeciesLabel.setTitle(_("coser.ui.selection.sizeAllYearSpecies", selectionSizeAllYearList.getSelectedIndices().length, selectionSizeAllYearList.getModel().getSize()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getAllSpeciesCommentField() {
        return allSpeciesCommentField;
    }

    public JXTitledSeparator getAllSpeciesLabel() {
        return allSpeciesLabel;
    }

    public JButton getApplyOccDensFilter() {
        return applyOccDensFilter;
    }

    public SelectionHandler getHandler() {
        return handler;
    }

    public JTextArea getMaturityCommentField() {
        return maturityCommentField;
    }

    public JXTitledSeparator getMaturitySpeciesLabel() {
        return maturitySpeciesLabel;
    }

    public JTextArea getOccurrenceDensityCommentField() {
        return occurrenceDensityCommentField;
    }

    public JXTitledSeparator getOccurrenceDensitySpeciesLabel() {
        return occurrenceDensitySpeciesLabel;
    }

    public JButton getSaveSelectionButton() {
        return saveSelectionButton;
    }

    public Selection getSelection() {
        return selection;
    }

    public JList getSelectionAllSpeciesList() {
        return selectionAllSpeciesList;
    }

    public SpeciesListModel getSelectionAllSpeciesListModel() {
        return selectionAllSpeciesListModel;
    }

    public JTextField getSelectionFilterDensityField() {
        return selectionFilterDensityField;
    }

    public JTextField getSelectionFilterOccurrenceField() {
        return selectionFilterOccurrenceField;
    }

    public JList getSelectionMaturityList() {
        return selectionMaturityList;
    }

    public MaturitySpeciesListModel getSelectionMaturityListModel() {
        return selectionMaturityListModel;
    }

    public JList getSelectionOccurrenceDensityList() {
        return selectionOccurrenceDensityList;
    }

    public OccurrenceDensitySpeciesListModel getSelectionOccurrenceDensityListModel() {
        return selectionOccurrenceDensityListModel;
    }

    public JList getSelectionSizeAllYearList() {
        return selectionSizeAllYearList;
    }

    public SizeAllYearSpeciesListModel getSelectionSizeAllYearListModel() {
        return selectionSizeAllYearListModel;
    }

    public JTextArea getSizeAllYearCommentField() {
        return sizeAllYearCommentField;
    }

    public JXTitledSeparator getSizeAllYearSpeciesLabel() {
        return sizeAllYearSpeciesLabel;
    }

    public JButton getValidSelectionButton() {
        return validSelectionButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void set$Document3(Document $Document3) {
        Document oldValue = this.$Document3;
        this.$Document3 = $Document3;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, $Document3);
    }

    public void set$Document4(Document $Document4) {
        Document oldValue = this.$Document4;
        this.$Document4 = $Document4;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, $Document4);
    }

    public void set$Document5(Document $Document5) {
        Document oldValue = this.$Document5;
        this.$Document5 = $Document5;
        firePropertyChange(PROPERTY$DOCUMENT5, oldValue, $Document5);
    }

    public void setHandler(SelectionHandler handler) {
        SelectionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelection(Selection selection) {
        Selection oldValue = this.selection;
        this.selection = selection;
        firePropertyChange(PROPERTY_SELECTION, oldValue, selection);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JButton get$JButton7() {
        return $JButton7;
    }

    protected JButton get$JButton8() {
        return $JButton8;
    }

    protected JButton get$JButton9() {
        return $JButton9;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected Document get$Document3() {
        return $Document3;
    }

    protected JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected Document get$Document4() {
        return $Document4;
    }

    protected JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected Document get$Document5() {
        return $Document5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAllSpeciesCommentField() {
        $objectMap.put("allSpeciesCommentField", allSpeciesCommentField = new JTextArea());
        
        allSpeciesCommentField.setName("allSpeciesCommentField");
        allSpeciesCommentField.setColumns(15);
        allSpeciesCommentField.setLineWrap(true);
        allSpeciesCommentField.setWrapStyleWord(true);
        allSpeciesCommentField.setRows(3);
    }

    protected void createAllSpeciesLabel() {
        $objectMap.put("allSpeciesLabel", allSpeciesLabel = new JXTitledSeparator());
        
        allSpeciesLabel.setName("allSpeciesLabel");
    }

    protected void createApplyOccDensFilter() {
        $objectMap.put("applyOccDensFilter", applyOccDensFilter = new JButton());
        
        applyOccDensFilter.setName("applyOccDensFilter");
        applyOccDensFilter.setEnabled(false);
        applyOccDensFilter.setText(_("coser.ui.selection.filter.filter"));
        applyOccDensFilter.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__applyOccDensFilter"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createMaturityCommentField() {
        $objectMap.put("maturityCommentField", maturityCommentField = new JTextArea());
        
        maturityCommentField.setName("maturityCommentField");
        maturityCommentField.setColumns(15);
        maturityCommentField.setLineWrap(true);
        maturityCommentField.setWrapStyleWord(true);
        maturityCommentField.setRows(3);
    }

    protected void createMaturitySpeciesLabel() {
        $objectMap.put("maturitySpeciesLabel", maturitySpeciesLabel = new JXTitledSeparator());
        
        maturitySpeciesLabel.setName("maturitySpeciesLabel");
    }

    protected void createOccurrenceDensityCommentField() {
        $objectMap.put("occurrenceDensityCommentField", occurrenceDensityCommentField = new JTextArea());
        
        occurrenceDensityCommentField.setName("occurrenceDensityCommentField");
        occurrenceDensityCommentField.setColumns(15);
        occurrenceDensityCommentField.setLineWrap(true);
        occurrenceDensityCommentField.setWrapStyleWord(true);
        occurrenceDensityCommentField.setRows(3);
    }

    protected void createOccurrenceDensitySpeciesLabel() {
        $objectMap.put("occurrenceDensitySpeciesLabel", occurrenceDensitySpeciesLabel = new JXTitledSeparator());
        
        occurrenceDensitySpeciesLabel.setName("occurrenceDensitySpeciesLabel");
    }

    protected void createSaveSelectionButton() {
        $objectMap.put("saveSelectionButton", saveSelectionButton = new JButton());
        
        saveSelectionButton.setName("saveSelectionButton");
        saveSelectionButton.setText(_("coser.ui.selection.details.saveSelection"));
        saveSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveSelectionButton"));
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    protected void createSelectionAllSpeciesList() {
        $objectMap.put("selectionAllSpeciesList", selectionAllSpeciesList = new JList());
        
        selectionAllSpeciesList.setName("selectionAllSpeciesList");
        selectionAllSpeciesList.setEnabled(false);
        selectionAllSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionAllSpeciesList"));
    }

    protected void createSelectionAllSpeciesListModel() {
        $objectMap.put("selectionAllSpeciesListModel", selectionAllSpeciesListModel = new SpeciesListModel());
        
        selectionAllSpeciesListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionAllSpeciesListModel"));
    }

    protected void createSelectionFilterDensityField() {
        $objectMap.put("selectionFilterDensityField", selectionFilterDensityField = new JTextField());
        
        selectionFilterDensityField.setName("selectionFilterDensityField");
        selectionFilterDensityField.setColumns(15);
        selectionFilterDensityField.setColumns(3);
    }

    protected void createSelectionFilterOccurrenceField() {
        $objectMap.put("selectionFilterOccurrenceField", selectionFilterOccurrenceField = new JTextField());
        
        selectionFilterOccurrenceField.setName("selectionFilterOccurrenceField");
        selectionFilterOccurrenceField.setColumns(15);
        selectionFilterOccurrenceField.setColumns(3);
    }

    protected void createSelectionMaturityList() {
        $objectMap.put("selectionMaturityList", selectionMaturityList = new JList());
        
        selectionMaturityList.setName("selectionMaturityList");
        selectionMaturityList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionMaturityList"));
    }

    protected void createSelectionMaturityListModel() {
        $objectMap.put("selectionMaturityListModel", selectionMaturityListModel = new MaturitySpeciesListModel());
        
        selectionMaturityListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionMaturityListModel"));
    }

    protected void createSelectionOccurrenceDensityList() {
        $objectMap.put("selectionOccurrenceDensityList", selectionOccurrenceDensityList = new JList());
        
        selectionOccurrenceDensityList.setName("selectionOccurrenceDensityList");
        selectionOccurrenceDensityList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionOccurrenceDensityList"));
    }

    protected void createSelectionOccurrenceDensityListModel() {
        $objectMap.put("selectionOccurrenceDensityListModel", selectionOccurrenceDensityListModel = new OccurrenceDensitySpeciesListModel());
        
        selectionOccurrenceDensityListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionOccurrenceDensityListModel"));
    }

    protected void createSelectionSizeAllYearList() {
        $objectMap.put("selectionSizeAllYearList", selectionSizeAllYearList = new JList());
        
        selectionSizeAllYearList.setName("selectionSizeAllYearList");
        selectionSizeAllYearList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionSizeAllYearList"));
    }

    protected void createSelectionSizeAllYearListModel() {
        $objectMap.put("selectionSizeAllYearListModel", selectionSizeAllYearListModel = new SizeAllYearSpeciesListModel());
        
        selectionSizeAllYearListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionSizeAllYearListModel"));
    }

    protected void createSizeAllYearCommentField() {
        $objectMap.put("sizeAllYearCommentField", sizeAllYearCommentField = new JTextArea());
        
        sizeAllYearCommentField.setName("sizeAllYearCommentField");
        sizeAllYearCommentField.setColumns(15);
        sizeAllYearCommentField.setLineWrap(true);
        sizeAllYearCommentField.setWrapStyleWord(true);
        sizeAllYearCommentField.setRows(3);
    }

    protected void createSizeAllYearSpeciesLabel() {
        $objectMap.put("sizeAllYearSpeciesLabel", sizeAllYearSpeciesLabel = new JXTitledSeparator());
        
        sizeAllYearSpeciesLabel.setName("sizeAllYearSpeciesLabel");
    }

    protected void createValidSelectionButton() {
        $objectMap.put("validSelectionButton", validSelectionButton = new JButton());
        
        validSelectionButton.setName("validSelectionButton");
        validSelectionButton.setText(_("coser.ui.selection.details.validSelection"));
        validSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSelectionButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 8, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(allSpeciesLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(occurrenceDensitySpeciesLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(sizeAllYearSpeciesLabel, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(maturitySpeciesLabel, new GridBagConstraints(6, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JPanel0, new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(2, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane2, new GridBagConstraints(4, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane3, new GridBagConstraints(6, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton2, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton3, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton4, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton5, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton6, new GridBagConstraints(4, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton7, new GridBagConstraints(5, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton8, new GridBagConstraints(6, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton9, new GridBagConstraints(7, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel4, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel5, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel6, new GridBagConstraints(4, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel7, new GridBagConstraints(6, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane4, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane5, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane6, new GridBagConstraints(4, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane7, new GridBagConstraints(6, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add(saveSelectionButton);
        $JToolBar0.add(validSelectionButton);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(selectionFilterOccurrenceField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(selectionFilterDensityField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(applyOccDensFilter, new GridBagConstraints(0, 1, 6, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(selectionAllSpeciesList);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(selectionOccurrenceDensityList);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(selectionSizeAllYearList);
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(selectionMaturityList);
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(allSpeciesCommentField);
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add(occurrenceDensityCommentField);
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(sizeAllYearCommentField);
        // inline complete setup of $JScrollPane7
        $JScrollPane7.getViewport().add(maturityCommentField);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        saveSelectionButton.setIcon(SwingUtil.createImageIcon("disk.png"));
        validSelectionButton.setIcon(SwingUtil.createImageIcon("accept.png"));
        allSpeciesLabel.setTitle(_("coser.ui.selection.allSpecies", 0, 0));
        occurrenceDensitySpeciesLabel.setTitle(_("coser.ui.selection.occurrenceDensitySpecies", 0, 0));
        sizeAllYearSpeciesLabel.setTitle(_("coser.ui.selection.sizeAllYearSpecies", 0, 0));
        maturitySpeciesLabel.setTitle(_("coser.ui.selection.maturitySpecies", 0, 0));
        $JButton0.setIcon(SwingUtil.createImageIcon("chart_curve.png"));
        $JButton1.setIcon(SwingUtil.createImageIcon("chart_bar.png"));
        selectionAllSpeciesList.setModel(selectionAllSpeciesListModel);
        selectionOccurrenceDensityList.setCellRenderer(new SpeciesListOccDensRenderer());
        selectionOccurrenceDensityList.setModel(selectionOccurrenceDensityListModel);
        selectionSizeAllYearList.setModel(selectionSizeAllYearListModel);
        selectionMaturityList.setModel(selectionMaturityListModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelection();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createSaveSelectionButton();
        createValidSelectionButton();
        createAllSpeciesLabel();
        createOccurrenceDensitySpeciesLabel();
        createSizeAllYearSpeciesLabel();
        createMaturitySpeciesLabel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.selection.filter.occurrence"));
        createSelectionFilterOccurrenceField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = selectionFilterOccurrenceField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.selection.filter.occurrenceunit"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.selection.filter.density"));
        createSelectionFilterDensityField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = selectionFilterDensityField.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.selection.filter.densityunit"));
        createApplyOccDensFilter();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("coser.ui.graph.compareNumberCatchLength"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("coser.ui.graph.lengthStructure"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSelectionAllSpeciesListModel();
        createSelectionAllSpeciesList();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSelectionOccurrenceDensityListModel();
        createSelectionOccurrenceDensityList();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSelectionSizeAllYearListModel();
        createSelectionSizeAllYearList();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createSelectionMaturityListModel();
        createSelectionMaturityList();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setEnabled(false);
        $JButton2.setText(_("coser.ui.common.selectAll.short"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setEnabled(false);
        $JButton3.setText(_("coser.ui.common.unselectAll.short"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("coser.ui.common.selectAll.short"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("coser.ui.common.unselectAll.short"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("coser.ui.common.selectAll.short"));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        // inline creation of $JButton7
        $objectMap.put("$JButton7", $JButton7 = new JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.setText(_("coser.ui.common.unselectAll.short"));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        // inline creation of $JButton8
        $objectMap.put("$JButton8", $JButton8 = new JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.setText(_("coser.ui.common.selectAll.short"));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        // inline creation of $JButton9
        $objectMap.put("$JButton9", $JButton9 = new JButton());
        
        $JButton9.setName("$JButton9");
        $JButton9.setText(_("coser.ui.common.unselectAll.short"));
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.selection.comment"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.selection.comment"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("coser.ui.selection.comment"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("coser.ui.selection.comment"));
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createAllSpeciesCommentField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = allSpeciesCommentField.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        createOccurrenceDensityCommentField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = occurrenceDensityCommentField.getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new JScrollPane());
        
        $JScrollPane6.setName("$JScrollPane6");
        createSizeAllYearCommentField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = sizeAllYearCommentField.getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JScrollPane7
        $objectMap.put("$JScrollPane7", $JScrollPane7 = new JScrollPane());
        
        $JScrollPane7.setName("$JScrollPane7");
        createMaturityCommentField();
        // inline creation of $Document5
        $objectMap.put("$Document5", $Document5 = maturityCommentField.getDocument());
        
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document5"));
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document5"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_FILTER_OCCURRENCE_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("occurrenceFilter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(selectionFilterOccurrenceField, String.valueOf(getSelection().getOccurrenceFilter()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("occurrenceFilter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_FILTER_DENSITY_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("densityFilter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(selectionFilterDensityField, String.valueOf(getSelection().getDensityFilter()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("densityFilter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_ALL_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionAllSpeciesList != null) {
                    selectionAllSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionAllSpeciesList != null) {
                    selectionAllSpeciesList.setSelectionModel(new CoserListSelectionModel(selectionAllSpeciesList.getSelectionModel(), selectionAllSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionAllSpeciesList != null) {
                    selectionAllSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_OCCURRENCE_DENSITY_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionOccurrenceDensityList != null) {
                    selectionOccurrenceDensityList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionOccurrenceDensityList != null) {
                    selectionOccurrenceDensityList.setSelectionModel(new CoserListSelectionModel(selectionOccurrenceDensityList.getSelectionModel(), selectionOccurrenceDensityListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionOccurrenceDensityList != null) {
                    selectionOccurrenceDensityList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_SIZE_ALL_YEAR_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionSizeAllYearList != null) {
                    selectionSizeAllYearList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionSizeAllYearList != null) {
                    selectionSizeAllYearList.setSelectionModel(new CoserListSelectionModel(selectionSizeAllYearList.getSelectionModel(), selectionSizeAllYearListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionSizeAllYearList != null) {
                    selectionSizeAllYearList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_MATURITY_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionMaturityList != null) {
                    selectionMaturityList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionMaturityList != null) {
                    selectionMaturityList.setSelectionModel(new CoserListSelectionModel(selectionMaturityList.getSelectionModel(), selectionMaturityListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionMaturityList != null) {
                    selectionMaturityList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ALL_SPECIES_COMMENT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(allSpeciesCommentField, getSelection().getSelectedSpeciesComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OCCURRENCE_DENSITY_COMMENT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesOccDensComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(occurrenceDensityCommentField, getSelection().getSelectedSpeciesOccDensComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesOccDensComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIZE_ALL_YEAR_COMMENT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesSizeAllYearComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(sizeAllYearCommentField, getSelection().getSelectedSpeciesSizeAllYearComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesSizeAllYearComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MATURITY_COMMENT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesMaturityComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(maturityCommentField, getSelection().getSelectedSpeciesMaturityComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesMaturityComment", this);
                }
            }
        });
    }

}