/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.ControlErrorGroup;
import fr.ifremer.coser.ui.control.GlobalControlErrorModel;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.nuiton.i18n.I18n;

public class ControlErrorTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6423364126451874968L;
    protected ImageIcon fatalIcon = SwingValidatorUtil.getFatalIcon();
    protected ImageIcon errorIcon = SwingValidatorUtil.getErrorIcon();
    protected ImageIcon warningIcon = SwingValidatorUtil.getWarningIcon();
    protected ImageIcon infoIcon = SwingValidatorUtil.getInfoIcon();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        GlobalControlErrorModel model = (GlobalControlErrorModel)((Object)tree.getModel());
        JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ImageIcon icon = null;
        String text = null;
        String tooltipText = null;
        if (value instanceof String) {
            text = I18n._((String)((String)value), (Object[])new Object[0]) + " (" + model.getChildCount(value) + ")";
        } else if (value instanceof CoserConstants.Category) {
            text = I18n._((String)((CoserConstants.Category)value).getTranslationKey(), (Object[])new Object[0]) + " (" + model.getChildCount(value) + ")";
        } else if (value instanceof ControlErrorGroup) {
            ControlErrorGroup validationErrorGroup = (ControlErrorGroup)value;
            CoserConstants.ValidationLevel level = validationErrorGroup.getValidationLevel();
            switch (level) {
                case FATAL: {
                    icon = this.fatalIcon;
                    break;
                }
                case ERROR: {
                    icon = this.errorIcon;
                    break;
                }
                case WARNING: {
                    icon = this.warningIcon;
                    break;
                }
                case INFO: {
                    icon = this.infoIcon;
                }
            }
            String message = validationErrorGroup.getMessage();
            text = I18n._((String)message, (Object[])new Object[0]) + " (" + model.getChildCount(value) + ")";
        } else if (value instanceof ControlError) {
            ControlError validationError = (ControlError)value;
            CoserConstants.ValidationLevel level = validationError.getLevel();
            switch (level) {
                case FATAL: {
                    icon = this.fatalIcon;
                    break;
                }
                case ERROR: {
                    icon = this.errorIcon;
                    break;
                }
                case WARNING: {
                    icon = this.warningIcon;
                    break;
                }
                case INFO: {
                    icon = this.infoIcon;
                }
            }
            String message = validationError.getDetailMessage();
            if (message == null) {
                message = validationError.getMessage();
            }
            text = I18n._((String)message, (Object[])new Object[0]);
            tooltipText = validationError.getTipMessage();
        }
        component.setText(text);
        component.setIcon(icon);
        component.setToolTipText(tooltipText);
        return component;
    }
}

