/*
 * #%L
 * $Id: CommandListRenderer.java 931 2011-12-23 15:13:08Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.5/coser-ui/src/main/java/fr/ifremer/coser/ui/selection/replay/CommandListRenderer.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.selection.replay;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import fr.ifremer.coser.command.Command;

/**
 * List cell renderer for command (display command description).
 * 
 * @author chatellier
 * @version $Revision: 931 $
 * 
 * Last update : $Date: 2011-12-23 16:13:08 +0100 (Fri, 23 Dec 2011) $
 * By : $Author: echatellier $
 */
public class CommandListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6780656602646606040L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        Command command = (Command)value;
        
        // can be null here. Renderer is currently used only un selection
        // replay where merge command don't use container to get desc
        String commandDesc = command.getDescription(null);

        return super.getListCellRendererComponent(list, commandDesc, index,
                isSelected, cellHasFocus);
    }
}
