/*
 * #%L
 * $Id: ControlTableModel.java 900 2011-11-17 14:22:37Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.5/coser-ui/src/main/java/fr/ifremer/coser/ui/control/ControlTableModel.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.control;

import javax.swing.table.AbstractTableModel;

import fr.ifremer.coser.CoserConstants.Category;

/**
 * Common interface for all data table model used in control view.
 * 
 * @author chatellier
 * @version $Revision: 900 $
 * 
 * Last update : $Date: 2011-11-17 15:22:37 +0100 (Thu, 17 Nov 2011) $
 * By : $Author: echatellier $
 */
public abstract class ControlTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2010447483214407634L;

    /**
     * Return category managed by model.
     * 
     * @return model category
     */
    public abstract Category getCategory();

    /**
     * Retourne la donnée (toutes le String[]) à la ligne demandée.
     * 
     * @param rowIndex
     * @return String[]
     */
    public abstract String[] getDataAt(int rowIndex);
    
    /**
     * Retourne l'index dans la liste des données du numero de ligne
     * demandé.
     * 
     * @param lineNumber le numero de données
     * @return l'index
     */
    public abstract int getRealIndexOfLine(String lineNumber);
}
