/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui;

import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.command.Command;
import fr.ifremer.coser.ui.control.ControlView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContainerRedoMenu
extends JMenu
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 2104672856535432709L;
    private static final Log log = LogFactory.getLog(ContainerRedoMenu.class);
    protected ControlView controlView;
    protected List<Command> redoableCommands = new ArrayList<Command>();

    public ContainerRedoMenu() {
        this.setEnabled(false);
    }

    public void setControlView(ControlView controlView) {
        if (this.controlView != null && this.controlView.getControl() != null) {
            this.controlView.getControl().removePropertyChangeListener("historyCommands", (PropertyChangeListener)this);
        }
        this.controlView = controlView;
        if (this.controlView != null && this.controlView.getControl() != null) {
            this.controlView.getControl().addPropertyChangeListener("historyCommands", (PropertyChangeListener)this);
        }
        this.updateSubMenuItems();
    }

    public List<Command> getCommands() {
        return this.redoableCommands;
    }

    public void setCommands(List<Command> redoableCommands) {
        this.redoableCommands = redoableCommands;
        this.updateSubMenuItems();
    }

    protected void updateSubMenuItems() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refresh redo menu items");
        }
        this.removeAll();
        boolean menuEnabled = false;
        if (this.controlView != null && this.controlView.getControl() != null) {
            Control control = this.controlView.getControl();
            menuEnabled = !this.redoableCommands.isEmpty();
            for (int i = this.redoableCommands.size() - 1; i >= 0 && i > this.redoableCommands.size() - 10; --i) {
                Command command = this.redoableCommands.get(i);
                JMenuItem commandMenu = new JMenuItem(command.getDescription((AbstractDataContainer)control));
                commandMenu.setActionCommand(String.valueOf(i));
                commandMenu.addActionListener(this);
                this.add(commandMenu);
            }
        }
        this.setEnabled(menuEnabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.redoableCommands.clear();
        this.updateSubMenuItems();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        int commandIndex = Integer.parseInt(actionCommand);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redo command index " + commandIndex));
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList<Command> newRedoCommands = new ArrayList<Command>(this.redoableCommands);
        for (int i = this.redoableCommands.size() - 1; i >= commandIndex; --i) {
            Command command = this.redoableCommands.get(i);
            commands.add(command);
            newRedoCommands.remove(command);
        }
        this.controlView.getHandler().redoCommands(this.controlView, commands);
        this.setCommands(newRedoCommands);
    }
}

