/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui;

import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.command.Command;
import fr.ifremer.coser.ui.ContainerRedoMenu;
import fr.ifremer.coser.ui.control.ControlView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContainerUndoMenu
extends JMenu
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 2104672856535432709L;
    private static final Log log = LogFactory.getLog(ContainerUndoMenu.class);
    protected ControlView controlView;
    protected ContainerRedoMenu redoMenu;

    public ContainerUndoMenu() {
        this.setEnabled(false);
    }

    public void setControlView(ControlView controlView) {
        if (this.controlView != null && this.controlView.getControl() != null) {
            this.controlView.getControl().removePropertyChangeListener("historyCommands", (PropertyChangeListener)this);
        }
        this.controlView = controlView;
        if (this.controlView != null && this.controlView.getControl() != null) {
            this.controlView.getControl().addPropertyChangeListener("historyCommands", (PropertyChangeListener)this);
        }
        this.updateSubMenuItems();
    }

    public void setRedoMenu(ContainerRedoMenu redoMenu) {
        this.redoMenu = redoMenu;
    }

    protected void updateSubMenuItems() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refresh undo menu items");
        }
        this.removeAll();
        boolean menuEnabled = false;
        if (this.controlView != null && this.controlView.getControl() != null) {
            Control control = this.controlView.getControl();
            List commands = this.controlView.getControl().getHistoryCommands();
            menuEnabled = !commands.isEmpty();
            for (int i = commands.size() - 1; i >= 0 && i > commands.size() - 10; --i) {
                Command command = (Command)commands.get(i);
                JMenuItem commandMenu = new JMenuItem(command.getDescription((AbstractDataContainer)control));
                commandMenu.setActionCommand(String.valueOf(i));
                commandMenu.addActionListener(this);
                this.add(commandMenu);
            }
        }
        this.setEnabled(menuEnabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateSubMenuItems();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        Control control = this.controlView.getControl();
        int commandIndex = Integer.parseInt(actionCommand);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undo command index " + commandIndex));
        }
        ArrayList<Command> redoCommands = new ArrayList<Command>(this.redoMenu.getCommands());
        List commands = this.controlView.getControl().getHistoryCommands();
        for (int i = commands.size() - 1; i >= commandIndex; --i) {
            redoCommands.add((Command)commands.get(i));
        }
        int count = control.getHistoryCommands().size() - commandIndex;
        this.controlView.getHandler().undoCommands(this.controlView, count);
        this.redoMenu.setCommands(redoCommands);
    }
}

