/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.result;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.storage.DataStorage;
import javax.swing.DefaultComboBoxModel;

public class ZoneComboBoxModel
extends DefaultComboBoxModel {
    private static final long serialVersionUID = 4452070553401468762L;
    protected DataStorage zonesMap;

    public ZoneComboBoxModel(WebService webService) {
        try {
            this.zonesMap = webService.getZonesMap();
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't get zone list", ex);
        }
    }

    @Override
    public int getSize() {
        return this.zonesMap.size() - 1;
    }

    @Override
    public Object getElementAt(int index) {
        return this.zonesMap.get(index + 1)[0];
    }

    public String[] getZone(String zoneId) {
        int index = this.zonesMap.indexOf(zoneId);
        String[] result = null;
        if (index != -1) {
            result = this.zonesMap.get(index);
        }
        return result;
    }
}

