/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.result;

import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.ui.selection.SelectionRsufiView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class ResultTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1192463259386773117L;
    protected Selection selection;

    public ResultTableModel(SelectionRsufiView view) {
        this.selection = view.getContextValue(Selection.class);
        this.selection.addPropertyChangeListener("rsufiResults", (PropertyChangeListener)this);
    }

    @Override
    public int getRowCount() {
        return this.selection.getRsufiResults().size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        String name = null;
        switch (column) {
            case 0: {
                name = I18n._((String)"coser.ui.result.table.resultName", (Object[])new Object[0]);
                break;
            }
            case 1: {
                name = I18n._((String)"coser.ui.result.table.rsufiVersion", (Object[])new Object[0]);
                break;
            }
            case 2: {
                name = I18n._((String)"coser.ui.result.table.zone", (Object[])new Object[0]);
                break;
            }
            case 3: {
                name = I18n._((String)"coser.ui.result.table.estComIndFile", (Object[])new Object[0]);
                break;
            }
            case 4: {
                name = I18n._((String)"coser.ui.result.table.estPopIndFile", (Object[])new Object[0]);
                break;
            }
            case 5: {
                name = I18n._((String)"coser.ui.result.table.maps", (Object[])new Object[0]);
                break;
            }
            case 6: {
                name = I18n._((String)"coser.ui.result.table.otherfiles", (Object[])new Object[0]);
            }
        }
        return name;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        RSufiResult rsufiResult = this.getValue(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = rsufiResult.getName();
                break;
            }
            case 1: {
                result = rsufiResult.getRsufiVersion();
                break;
            }
            case 2: {
                result = rsufiResult.getZone();
                break;
            }
            case 3: {
                result = rsufiResult.getEstComIndName();
                break;
            }
            case 4: {
                result = rsufiResult.getEstPopIndName();
                break;
            }
            case 5: {
                result = rsufiResult.isMapsAvailable();
                break;
            }
            case 6: {
                result = rsufiResult.isOtherFilesAvailable();
            }
        }
        return result;
    }

    public RSufiResult getValue(int rowIndex) {
        RSufiResult result = (RSufiResult)this.selection.getRsufiResults().get(rowIndex);
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }
}

