/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.widgets;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelViewMenuItem
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 2462162272156484217L;
    public static final String PROPERTY_LOOK_AND_FEEL = "lookAndFeel";
    protected String currentLookAndFeel;

    public LookAndFeelViewMenuItem() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        this.currentLookAndFeel = UIManager.getLookAndFeel().getClass().getName();
        ButtonGroup lookAndFeelRadioGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo lafInfo : lookAndFeelInfos) {
            JRadioButtonMenuItem lafItem = new JRadioButtonMenuItem();
            lafItem.setSelected(lafInfo.getClassName().equals(this.currentLookAndFeel));
            lafItem.setHideActionText(true);
            lafItem.addActionListener(this);
            lafItem.setText(lafInfo.getName());
            lafItem.setActionCommand(lafInfo.getClassName());
            lookAndFeelRadioGroup.add(lafItem);
            this.add(lafItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String lookAndFeel = event.getActionCommand();
        try {
            String oldLookAndFeel = this.currentLookAndFeel;
            if (!oldLookAndFeel.equals(lookAndFeel)) {
                UIManager.setLookAndFeel(lookAndFeel);
                this.currentLookAndFeel = lookAndFeel;
                this.updateLookAndFeel();
                this.firePropertyChange(PROPERTY_LOOK_AND_FEEL, oldLookAndFeel, lookAndFeel);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't install selected look and feel : " + lookAndFeel, ex);
        }
    }

    protected void updateLookAndFeel() {
        Window[] windows;
        for (Window window : windows = Frame.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }
}

