/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.project;

import fr.ifremer.coser.bean.Project;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ProjectEditView extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PROJECT = "project";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PROJECT_AUTHOR_TEXT = "projectAuthor.text";
    public static final String BINDING_PROJECT_COMMENT_TEXT = "projectComment.text";
    public static final String BINDING_PROJECT_MAPS_MODEL_MAPS = "projectMapsModel.maps";
    public static final String BINDING_PROJECT_PROJECT_NAME_TEXT = "projectProjectName.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTU8TQRieVgoUBPkIXxEiYGOimC2I0RgaAUGCTUGkhKC9ONsd6JLt7jozC+vF+BP8CXr3YuLNk/Hg2YMX418wxoNX4zuz226XbqGkPWzbmed55nk/9p33v1CCUTR1iF1XoY7J9TJRsst7e4/VQ1Lkq4QVqW5ziyLvE4ujeAF1a9V1xtHVQk7Q0z49vWKVbcskZg17IYe6GH9pEFYihHM0EWYUGUvnq9sLru3QimrVVJTq2z+/42+01+/iCLk2uBuBUCbPYgWRtOVQXNc4GoCTjnDawOYB2KC6eQB+e8TaioEZ28Rl8gK9Qh051G5jCmIcTTcfstSQfNfmqCO1g1WDzHI0s08VfZ+SMqFK0WLwdHTFppbIu7LlfT/UdL6rk2PblgrtwC9hUzMI5ehGE/x1D1xD9wFQgjq6SrBZIQaMPkIplFm63rA0YnCUCaX4CBu6hiFihR1D6pS8eO5WFjcIY/iABPQa5Spzq2Jq5hzKNUF5OZ3jaDTE91hyTyCTVUJnKpvDKjGgCgOizK4P9VYFaLQOOyf+T4T3Bvxs+v5Fo3A0HFLcIS5f04mhRaveilDt8VWXHV6yqFicDgO6UqtW0SlDu0EAY7XHcThNqWzadafNR52WyuaL1DKMLWyKthwJ2Q+2wqw+3+MGtpnfFbNN9KOA53TGT3RCd40aR/3hkgBcwG5W0clU9oHDuWWC28EQ1lsOO62iZQHvRpfh9lmJkWQlDOj1XcPLX5ZDYaiu8suUYIHORNROSl4PktDP8BHx8xQEUjFM0eVQb8PIVIKRGcy0WAElqAPL8DIU6qfsNmx583X0xHwVgnL33/Dg908/P65Vhmo/nD0UCa25E2DYQTZsmEu6OPqSN1EdrhtpKOpCASUZMSAweWGMRxjL+9tgDs6TLaAIurKOWQkkEh0/Pn8Zfv7tAoqvoS7DwtoaFvhHKMlLFLJgGZprLy5JRxePO+HZJ7xx1K5aVBMDszcDcwNPqrqpQYHuu5CE8YgkVJ2oya9/B/MfliqJiIGxsYbwIBmJZ6hdNw3dJPJ+8a+OyPuk22bE0azgioi6NGLie8z2OyUrn5tRkbaJ1x+mUsY7fRJzuMxUhxOIVZC2ZRDi147UHD9TUyzviceTaIUrTbjqIKaYwDIPT6Nlplo2cg6FBh5SLXu41rKHmWaKXMYepoGL2SY0EmUxf08RmW85lDtNKaineLjXsofWFRaaKQi1jtkpGostN9Y5FBp4WAWF/0cZFw3rCwAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    private static final Log log = LogFactory.getLog(ProjectEditView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SwingValidatorMessageTableModel errorsTableModel;
    protected ProjectHandler handler;
    protected Project project;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "author",  editorName = "projectAuthor")
    protected JTextField projectAuthor;
    protected JTextArea projectComment;
    protected JList projectMaps;
    protected ProjectMapsListModel projectMapsModel;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "name",  editorName = "projectProjectName")
    protected JTextField projectProjectName;
    protected JButton saveProjectButton;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorProject")
    protected SwingValidator<Project> validatorProject;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ProjectEditView $Table0 = this;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private Document $Document0;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel4;
    private JScrollPane $JScrollPane1;
    private Document $Document1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ProjectEditView() {
        $initialize();
    }

    public ProjectEditView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setComment(projectComment.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setComment(projectComment.getText());
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setAuthor(projectAuthor.getText());
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectMapFiles(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeSelectedMapFiles(this);
    }

    public void doActionPerformed__on__saveProjectButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveProject(this);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setAuthor(projectAuthor.getText());
    }

    public void doTableChanged__on__errorsTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveProjectButton.setEnabled(errorsTableModel.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public ProjectHandler getHandler() {
        return handler;
    }

    public Project getProject() {
        return project;
    }

    public JTextField getProjectAuthor() {
        return projectAuthor;
    }

    public JTextArea getProjectComment() {
        return projectComment;
    }

    public JList getProjectMaps() {
        return projectMaps;
    }

    public ProjectMapsListModel getProjectMapsModel() {
        return projectMapsModel;
    }

    public JTextField getProjectProjectName() {
        return projectProjectName;
    }

    public JButton getSaveProjectButton() {
        return saveProjectButton;
    }

    public SwingValidator<Project> getValidatorProject() {
        return validatorProject;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void setHandler(ProjectHandler handler) {
        ProjectHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setProject(Project project) {
        Project oldValue = this.project;
        this.project = project;
        firePropertyChange(PROPERTY_PROJECT, oldValue, project);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToValidatorProject() {
        if (!allComponentsCreated) {
            return;
        }
        validatorProject.setErrorTableModel(errorsTableModel);
        validatorProject.setUiClass(ImageValidationUI.class);
        validatorProject.setBean(project);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createProject() {
        $objectMap.put("project", project = null);
    }

    protected void createProjectAuthor() {
        $objectMap.put("projectAuthor", projectAuthor = new JTextField());
        
        projectAuthor.setName("projectAuthor");
        projectAuthor.setColumns(15);
    }

    protected void createProjectComment() {
        $objectMap.put("projectComment", projectComment = new JTextArea());
        
        projectComment.setName("projectComment");
        projectComment.setColumns(15);
        projectComment.setLineWrap(true);
        projectComment.setWrapStyleWord(true);
        projectComment.setRows(3);
    }

    protected void createProjectMaps() {
        $objectMap.put("projectMaps", projectMaps = new JList());
        
        projectMaps.setName("projectMaps");
    }

    protected void createProjectMapsModel() {
        $objectMap.put("projectMapsModel", projectMapsModel = new ProjectMapsListModel());
    }

    protected void createProjectProjectName() {
        $objectMap.put("projectProjectName", projectProjectName = new JTextField());
        
        projectProjectName.setName("projectProjectName");
        projectProjectName.setColumns(15);
        projectProjectName.setEnabled(false);
    }

    protected void createSaveProjectButton() {
        $objectMap.put("saveProjectButton", saveProjectButton = new JButton());
        
        saveProjectButton.setName("saveProjectButton");
        saveProjectButton.setText(_("coser.ui.project.saveProject"));
        saveProjectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveProjectButton"));
    }

    protected void createValidatorProject() {
        $objectMap.put("validatorProject", validatorProject = SwingValidatorUtil.newValidator(Project.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorProject();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectProjectName), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectAuthor), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 2, 2, 2, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(saveProjectButton, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(projectMaps);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(projectComment);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(_("coser.ui.project.editProject")));
        $JLabel1.setText(_(getContextValue(fr.ifremer.coser.CoserConfig.class).getProjectsDirectory().getAbsolutePath() + java.io.File.separator));
        projectMaps.setModel(projectMapsModel);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createProject();
        createErrorsTableModel();
        createValidatorProject();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.project.projectname"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        createProjectProjectName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.project.projectauthor"));
        createProjectAuthor();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = projectAuthor.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.project.maps"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createProjectMapsModel();
        createProjectMaps();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.project.addMaps"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.project.removeMaps"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.project.projectcomment"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createProjectComment();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = projectComment.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        createSaveProjectButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_PROJECT_NAME_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectProjectName, getProject().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_AUTHOR_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("author", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectAuthor, getProject().getAuthor());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("author", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_MAPS_MODEL_MAPS, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("maps", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    projectMapsModel.setMaps(getProject().getMaps());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("maps", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProjectMaps() != null) {
                    $bindingSources.put("getProjectMaps().getSelectionModel()", getProjectMaps().getSelectionModel());
                    getProjectMaps().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    getProjectMaps().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectEditView.this, BINDING_$JBUTTON1_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProjectMaps() != null && getProjectMaps().getSelectedIndices() != null) {
                    $JButton1.setEnabled(getProjectMaps().getSelectedIndices().length != 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProjectMaps() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("getProjectMaps().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    getProjectMaps().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectEditView.this, BINDING_$JBUTTON1_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectComment, getProject().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}