/*
 * #%L
 * Coser :: UI
 * 
 * $Id: ControlCategoryListRenderer.java 62 2010-10-18 14:40:59Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0/coser-ui/src/main/java/fr/ifremer/coser/ui/control/ControlCategoryListRenderer.java $
 * %%
 * Copyright (C) 2010 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.control;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import fr.ifremer.coser.CoserConstants.Category;

/**
 * Validation categories list model.
 * 
 * @author chatellier
 * @version $Revision: 62 $
 * 
 * Last update : $Date: 2010-10-18 16:40:59 +0200 (lun., 18 oct. 2010) $
 * By : $Author: chatellier $
 */
public class ControlCategoryListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -435184894102500045L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        Category category = (Category)value;
        String stringValue = _(category.getTranslationKey());
        
        return super.getListCellRendererComponent(list, stringValue, index, isSelected, cellHasFocus);
    }
}
