/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui;

import fr.ifremer.coser.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class CoserFrame extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROJECT = "project";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MENU_WINDOW_SELECTION_MENU_ITEM_PROJECT = "menuWindowSelectionMenuItem.project";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JMENU1_ENABLED = "$JMenu1.enabled";
    private static final String BINDING_$JMENU_ITEM2_ENABLED = "$JMenuItem2.enabled";
    private static final String BINDING_$JMENU_ITEM3_ENABLED = "$JMenuItem3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXQW8bRRSemDqpk0IhbUJDQ2WIUwSIdRqnpShRmjbFTYIDEZagqiXE2DuNp+zOLjuzeHtBXLjzE+DOBYkbJ8ShZw5cEH+hQhy4or6ZXa/teLxZMT6srfne98333ozfs398ioo8QK89wlFkBSET1CXWwe379z9qPyIdcZfwTkB94QUofk0VUKGF5ux0nQu00mpIejWhV3c91/cYYUPszQaa5eKxQ3iXECHQq6OMDufVZgpvRn4Y9FVTUzrV7//5u/Cd/c0PBYQiH9yVIZXyaaxBJmcaqEBtgeZhp69w1cHsGGwElB2D3+fl2q6DOf8Qu+RL9DWaaaBpHwcgJtDr+VNWGoof+QKdrRzUAxBcE+jKw8CiDwPiksDqeByeIQXD8EFF+L5iTQs008XMdkgg0Go2ZS+OG2L6gSfPESo+xmwTzKyjGB8wZisHh4SFd3AADi/KGkQW70FJrP76kHocC4EvjQXKkPk0ci6O3BfEheiFsWgJyNAFHeOaXHplIryeDdc08LnKQZPAUWI4J/CzOOInRSZKbmgkk1oory9PTP56yryqg29o4MsugJ9SZnu9JnHgrKjH+vECvaW7EGkcb1Auhut79aTf9Wy/76aGqieZtWzmzZRZ08HvaeDhU1F1XBnD0yuxpuen+DUNnhjf0BhfqjQ874vbzK4T4nxCSW/ottZ0Je5R+5gIbk2gSdlbJze+rtl42PPgIt/V4rVT8A0Nft7FlElnux4TqnPNj1z2I8yII2NLQx1gz3OJ5EDyy7rk+7gkNFLexUpTYBHyQ8I5PiZKGRRWR/pxvO14YGIhQJdHwmEwWIPBMOjcUy1UDEJYFuhSa3yWfAxQPEUunZgiUlCh/y1e+OOXv36u90fHCuy9oA0dmnzQ0qGh+tCJqdz6fDw3QkGd6iH2N1uoxNVXT43FZY2xZgKDOdhPdU1L0q09zLsgUZz589ffFj///TlUqKNZx8N2Hcv4fVQS3QCq4Dl25N/aUY7O9c7C80XpTaAS7Xhs34V6CvTClo0FLrehaUC1tyOow7KmDqmZdunJvxeaP+30azEF3pYmhg/qUXyApilzKCNqkCYzUjs453xOQtsbzELddJyS77N+MmAeqOdnumSnHfzYC4XEcaRGTVvZlp/s3CpnGPiDL8RWnEMZC5j97VCQ7f+vWRRUOCppZmBMkEhkaCyeqiGXowyFJWOF5Rx5zBCG2w6xM87pirGRfArfZngoG3swV1g1zuINYw/mCm8aK7yd51olP2ozivGOsRFzhTVjhXVjhQ1jhRvGCjfzdDw5vTLOc8vYRT6FJxketo09mCvsGCvcMVZ431jhnrHCvrHCB7kUuhn34TBPq0r+uWfIHIHMM+uSKruGEQAA";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.CoserFrame.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected fr.ifremer.coser.ui.CoserFrameHandler handler;
    protected javax.swing.JPanel mainViewContent;
    protected fr.ifremer.coser.ui.SelectionsListMenuItem menuWindowSelectionMenuItem;
    protected fr.ifremer.coser.bean.Project project;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoserFrame $JFrame0 = this;
    private javax.swing.JMenuBar $JMenuBar0;
    private javax.swing.JMenu $JMenu0;
    private javax.swing.JMenuItem $JMenuItem0;
    private javax.swing.JMenuItem $JMenuItem1;
    private javax.swing.JMenuItem $JMenuItem2;
    private javax.swing.JMenuItem $JMenuItem3;
    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JMenuItem $JMenuItem4;
    private javax.swing.JMenu $JMenu1;
    private javax.swing.JMenuItem $JMenuItem5;
    private javax.swing.JMenuItem $JMenuItem6;
    private javax.swing.JMenu $JMenu2;
    private javax.swing.JMenuItem $JMenuItem7;
    private javax.swing.JMenu $JMenu3;
    private javax.swing.JMenuItem $JMenuItem8;
    private javax.swing.JMenuItem $JMenuItem9;
    private javax.swing.JSeparator $JSeparator1;
    private javax.swing.JMenuItem $JMenuItem10;
    private javax.swing.JMenuItem $JMenuItem11;
    private javax.swing.JMenu $JMenu4;
    private fr.ifremer.coser.ui.widgets.LookAndFeelViewMenuItem $LookAndFeelViewMenuItem0;
    private javax.swing.JMenu $JMenu5;
    private javax.swing.JMenuItem $JMenuItem12;
    private javax.swing.JMenuItem $JMenuItem13;
    private javax.swing.JMenuItem $JMenuItem14;
    private fr.ifremer.coser.ui.HomeView $HomeView0;
    private jaxx.runtime.swing.StatusMessagePanel $StatusMessagePanel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoserFrame() {
        $initialize();
    }

    public CoserFrame(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem10(java.awt.event.ActionEvent event) {
        getHandler().switchLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__$JMenuItem14(java.awt.event.ActionEvent event) {
        getHandler().showAboutView();
    }

    public void doPropertyChange__on__$LookAndFeelViewMenuItem0(java.beans.PropertyChangeEvent event) {
        getHandler().saveLookAndFeelConfiguration(event);
    }

    public void doActionPerformed__on__$JMenuItem9(java.awt.event.ActionEvent event) {
        getHandler().showValidatorsConfiguration();
    }

    public void doActionPerformed__on__$JMenuItem13(java.awt.event.ActionEvent event) {
        getHandler().showCoserWebsiteSIH();
    }

    public void doActionPerformed__on__$JMenuItem8(java.awt.event.ActionEvent event) {
        getHandler().showCoserConfiguration();
    }

    public void doActionPerformed__on__$JMenuItem12(java.awt.event.ActionEvent event) {
        getHandler().showCoserWebsite();
    }

    public void doActionPerformed__on__$JMenuItem11(java.awt.event.ActionEvent event) {
        getHandler().switchLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__$JMenuItem6(java.awt.event.ActionEvent event) {
        getHandler().showControlView();
    }

    public void doActionPerformed__on__$JMenuItem7(java.awt.event.ActionEvent event) {
        getHandler().showPublishResultView();
    }

    public void doActionPerformed__on__$JMenuItem4(java.awt.event.ActionEvent event) {
        getHandler().quit();
    }

    public void doActionPerformed__on__$JMenuItem5(java.awt.event.ActionEvent event) {
        getHandler().showSummaryView();
    }

    public void doActionPerformed__on__$JMenuItem2(java.awt.event.ActionEvent event) {
        getHandler().showProjectEditView();
    }

    public void doActionPerformed__on__$JMenuItem3(java.awt.event.ActionEvent event) {
        getHandler().closeProject();
    }

    public void doActionPerformed__on__$JMenuItem0(java.awt.event.ActionEvent event) {
        getHandler().showProjectCreationView();
    }

    public void doActionPerformed__on__$JMenuItem1(java.awt.event.ActionEvent event) {
        getHandler().showProjectOpenView();
    }

    public void doWindowClosing__on__$JFrame0(java.awt.event.WindowEvent event) {
        getHandler().quit();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public fr.ifremer.coser.ui.CoserFrameHandler getHandler() {
        return handler;
    }

    public javax.swing.JPanel getMainViewContent() {
        return mainViewContent;
    }

    public fr.ifremer.coser.ui.SelectionsListMenuItem getMenuWindowSelectionMenuItem() {
        return menuWindowSelectionMenuItem;
    }

    public fr.ifremer.coser.bean.Project getProject() {
        return project;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProject(fr.ifremer.coser.bean.Project newValue) {
        fr.ifremer.coser.bean.Project oldValue = this.project;
        this.project = newValue;
        firePropertyChange(PROPERTY_PROJECT, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected javax.swing.JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected javax.swing.JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected javax.swing.JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected javax.swing.JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected javax.swing.JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected javax.swing.JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected javax.swing.JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected javax.swing.JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected javax.swing.JMenu get$JMenu2() {
        return $JMenu2;
    }

    protected javax.swing.JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected javax.swing.JMenu get$JMenu3() {
        return $JMenu3;
    }

    protected javax.swing.JMenuItem get$JMenuItem8() {
        return $JMenuItem8;
    }

    protected javax.swing.JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected javax.swing.JMenuItem get$JMenuItem10() {
        return $JMenuItem10;
    }

    protected javax.swing.JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected javax.swing.JMenu get$JMenu4() {
        return $JMenu4;
    }

    protected fr.ifremer.coser.ui.widgets.LookAndFeelViewMenuItem get$LookAndFeelViewMenuItem0() {
        return $LookAndFeelViewMenuItem0;
    }

    protected javax.swing.JMenu get$JMenu5() {
        return $JMenu5;
    }

    protected javax.swing.JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected javax.swing.JMenuItem get$JMenuItem13() {
        return $JMenuItem13;
    }

    protected javax.swing.JMenuItem get$JMenuItem14() {
        return $JMenuItem14;
    }

    protected fr.ifremer.coser.ui.HomeView get$HomeView0() {
        return $HomeView0;
    }

    protected jaxx.runtime.swing.StatusMessagePanel get$StatusMessagePanel0() {
        return $StatusMessagePanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainViewContent() {
        if (!allComponentsCreated) {
            return;
        }
        mainViewContent.add($HomeView0);
    }

    protected void create$LookAndFeelViewMenuItem0() {
        $objectMap.put("$LookAndFeelViewMenuItem0", $LookAndFeelViewMenuItem0 = new fr.ifremer.coser.ui.widgets.LookAndFeelViewMenuItem());
        
        $LookAndFeelViewMenuItem0.setName("$LookAndFeelViewMenuItem0");
        $LookAndFeelViewMenuItem0.setText(_("coser.ui.mainframe.menu.view.lookandfeel"));
        $LookAndFeelViewMenuItem0.addPropertyChangeListener(JAXXUtil.getEventListener(PropertyChangeListener.class, "propertyChange", this, "doPropertyChange__on__$LookAndFeelViewMenuItem0"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new fr.ifremer.coser.ui.CoserFrameHandler(this));
    }

    protected void createMainViewContent() {
        $objectMap.put("mainViewContent", mainViewContent = new javax.swing.JPanel());
        
        mainViewContent.setName("mainViewContent");
        mainViewContent.setLayout(new BorderLayout());
    }

    protected void createMenuWindowSelectionMenuItem() {
        $objectMap.put("menuWindowSelectionMenuItem", menuWindowSelectionMenuItem = new fr.ifremer.coser.ui.SelectionsListMenuItem(this));
        
        menuWindowSelectionMenuItem.setName("menuWindowSelectionMenuItem");
        menuWindowSelectionMenuItem.setText(_("coser.ui.mainframe.menu.data.selections"));
    }

    protected void createProject() {
        $objectMap.put("project", project = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JFrame0
        add(mainViewContent, BorderLayout.CENTER);
        add($StatusMessagePanel0, BorderLayout.SOUTH);
        $JFrame0.setJMenuBar($JMenuBar0);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        $JMenuBar0.add($JMenu1);
        $JMenuBar0.add($JMenu2);
        $JMenuBar0.add($JMenu3);
        $JMenuBar0.add($JMenu4);
        $JMenuBar0.add($JMenu5);
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem0);
        $JMenu0.add($JMenuItem1);
        $JMenu0.add($JMenuItem2);
        $JMenu0.add($JMenuItem3);
        $JMenu0.add($JSeparator0);
        $JMenu0.add($JMenuItem4);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenuItem5);
        $JMenu1.add($JMenuItem6);
        $JMenu1.add(menuWindowSelectionMenuItem);
        // inline complete setup of $JMenu2
        $JMenu2.add($JMenuItem7);
        // inline complete setup of $JMenu3
        $JMenu3.add($JMenuItem8);
        $JMenu3.add($JMenuItem9);
        $JMenu3.add($JSeparator1);
        $JMenu3.add($JMenuItem10);
        $JMenu3.add($JMenuItem11);
        // inline complete setup of $JMenu4
        $JMenu4.add($LookAndFeelViewMenuItem0);
        // inline complete setup of $JMenu5
        $JMenu5.add($JMenuItem12);
        $JMenu5.add($JMenuItem13);
        $JMenu5.add($JMenuItem14);
        addChildrenToMainViewContent();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setIconImage(SwingUtil.createImageIcon("logo.png").getImage());
        $JMenuItem10.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-fr"));
        $JMenuItem11.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-gb"));
        $HomeView0.setHandler(getHandler());
        // late initializer
        $JFrame0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JFrame0", this);
        createHandler();
        createProject();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new javax.swing.JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new javax.swing.JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(_("coser.ui.mainframe.menu.file"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new javax.swing.JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(_("coser.ui.mainframe.menu.newProject"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new javax.swing.JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(_("coser.ui.mainframe.menu.openProject"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new javax.swing.JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(_("coser.ui.mainframe.menu.editProject"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new javax.swing.JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(_("coser.ui.mainframe.menu.closeProject"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new javax.swing.JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(_("coser.ui.mainframe.menu.quit"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new javax.swing.JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(_("coser.ui.mainframe.menu.data"));
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new javax.swing.JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(_("coser.ui.mainframe.menu.data.summary"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JMenuItem6
        $objectMap.put("$JMenuItem6", $JMenuItem6 = new javax.swing.JMenuItem());
        
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(_("coser.ui.mainframe.menu.data.control"));
        $JMenuItem6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem6"));
        createMenuWindowSelectionMenuItem();
        // inline creation of $JMenu2
        $objectMap.put("$JMenu2", $JMenu2 = new javax.swing.JMenu());
        
        $JMenu2.setName("$JMenu2");
        $JMenu2.setText(_("coser.ui.mainframe.menu.admin"));
        // inline creation of $JMenuItem7
        $objectMap.put("$JMenuItem7", $JMenuItem7 = new javax.swing.JMenuItem());
        
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(_("coser.ui.mainframe.menu.admin.publishResult"));
        $JMenuItem7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem7"));
        // inline creation of $JMenu3
        $objectMap.put("$JMenu3", $JMenu3 = new javax.swing.JMenu());
        
        $JMenu3.setName("$JMenu3");
        $JMenu3.setText(_("coser.ui.mainframe.menu.options"));
        // inline creation of $JMenuItem8
        $objectMap.put("$JMenuItem8", $JMenuItem8 = new javax.swing.JMenuItem());
        
        $JMenuItem8.setName("$JMenuItem8");
        $JMenuItem8.setText(_("coser.ui.mainframe.menu.configuration"));
        $JMenuItem8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem8"));
        // inline creation of $JMenuItem9
        $objectMap.put("$JMenuItem9", $JMenuItem9 = new javax.swing.JMenuItem());
        
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setText(_("coser.ui.mainframe.menu.validators"));
        $JMenuItem9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem9"));
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JMenuItem10
        $objectMap.put("$JMenuItem10", $JMenuItem10 = new javax.swing.JMenuItem());
        
        $JMenuItem10.setName("$JMenuItem10");
        $JMenuItem10.setText(_("coser.ui.mainframe.menu.locale.fr"));
        $JMenuItem10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem10"));
        // inline creation of $JMenuItem11
        $objectMap.put("$JMenuItem11", $JMenuItem11 = new javax.swing.JMenuItem());
        
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(_("coser.ui.mainframe.menu.locale.uk"));
        $JMenuItem11.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem11"));
        // inline creation of $JMenu4
        $objectMap.put("$JMenu4", $JMenu4 = new javax.swing.JMenu());
        
        $JMenu4.setName("$JMenu4");
        $JMenu4.setText(_("coser.ui.mainframe.menu.view"));
        create$LookAndFeelViewMenuItem0();
        // inline creation of $JMenu5
        $objectMap.put("$JMenu5", $JMenu5 = new javax.swing.JMenu());
        
        $JMenu5.setName("$JMenu5");
        $JMenu5.setText(_("coser.ui.mainframe.menu.help"));
        // inline creation of $JMenuItem12
        $objectMap.put("$JMenuItem12", $JMenuItem12 = new javax.swing.JMenuItem());
        
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(_("coser.ui.mainframe.menu.website"));
        $JMenuItem12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem12"));
        // inline creation of $JMenuItem13
        $objectMap.put("$JMenuItem13", $JMenuItem13 = new javax.swing.JMenuItem());
        
        $JMenuItem13.setName("$JMenuItem13");
        $JMenuItem13.setText(_("coser.ui.mainframe.menu.websitesih"));
        $JMenuItem13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem13"));
        // inline creation of $JMenuItem14
        $objectMap.put("$JMenuItem14", $JMenuItem14 = new javax.swing.JMenuItem());
        
        $JMenuItem14.setName("$JMenuItem14");
        $JMenuItem14.setText(_("coser.ui.mainframe.menu.about"));
        $JMenuItem14.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem14"));
        createMainViewContent();
        // inline creation of $HomeView0
        $objectMap.put("$HomeView0", $HomeView0 = new fr.ifremer.coser.ui.HomeView());
        
        $HomeView0.setName("$HomeView0");
        // inline creation of $StatusMessagePanel0
        $objectMap.put("$StatusMessagePanel0", $StatusMessagePanel0 = new jaxx.runtime.swing.StatusMessagePanel());
        
        $StatusMessagePanel0.setName("$StatusMessagePanel0");
        // inline creation of $JFrame0
        setName("$JFrame0");
        $JFrame0.getContentPane().setLayout(new BorderLayout());
        setName("mainFrame");
        setTitle(_("coser.ui.mainview.titleempty"));
        $JFrame0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JFrame0"));
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM2_ENABLED, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem2.setEnabled(getProject() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM3_ENABLED, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem3.setEnabled(getProject() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU1_ENABLED, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $JMenu1.setEnabled(getProject() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_WINDOW_SELECTION_MENU_ITEM_PROJECT, true ,"project") {
        
            @Override
            public void processDataBinding() {
                menuWindowSelectionMenuItem.setProject(getProject());
            }
        });
    }

}