/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.maps;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.layer.GraticuleLayer;
import com.bbn.openmap.layer.shape.ShapeLayer;
import fr.ifremer.coser.bean.Project;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoserMap
extends BufferedMapBean {
    private static final long serialVersionUID = 3134624721243512358L;
    private static final Log log = LogFactory.getLog(CoserMap.class);
    protected LayerHandler layerHandler = new LayerHandler();
    protected MapMouseMode currentMouseMode;
    protected MouseDelegator md;
    protected static final float SCALE = 9500000.0f;

    public CoserMap() {
        this.setScale(9500000.0f);
        this.md = new MouseDelegator((MapBean)this);
        this.md.setDefaultMouseModes();
        this.setActiveMouseMode((MapMouseMode)new NavMouseMode());
        this.layerHandler.addLayerListener((LayerListener)this);
    }

    public void setActiveMouseMode(MapMouseMode mode) {
        this.md.setActiveMouseMode(mode);
        this.currentMouseMode = mode;
    }

    public void initMap(Project project) {
        this.setCenter(50.0f, 0.0f);
        this.setScale(1.6E7f);
        this.addGraticuleLayer();
        boolean cntrOOShapeFound = false;
        if (project.getMaps() != null) {
            for (File map : project.getMaps()) {
                if (!map.getName().equals("cntry00.shp")) continue;
                cntrOOShapeFound = true;
            }
        }
        if (!cntrOOShapeFound) {
            this.addLayer("maps/vmap_area_thin.shp", "maps/vmap_area_thin.shp", "ff000000", "ffbdde83");
        }
        if (project.getMaps() != null) {
            for (File map : project.getMaps()) {
                if (map.getName().equals("cntry00.shp")) {
                    this.addLayer(map.getAbsolutePath(), map.getAbsolutePath(), "ff000000", "ffbdde83");
                    continue;
                }
                this.addLayer(map.getAbsolutePath(), map.getAbsolutePath(), "ff000000", "ffE55B3C");
            }
        }
    }

    protected void addGraticuleLayer() {
        GraticuleLayer layer = new GraticuleLayer();
        Properties p = new Properties();
        p.setProperty(".showRuler", "true");
        p.setProperty(".show1And5Lines", "true");
        p.setProperty(".threshold", "5");
        p.setProperty(".10DegreeColor", "FF000000");
        p.setProperty(".5DegreeColor", "C7009900");
        p.setProperty(".1DegreeColor", "FF003300");
        p.setProperty(".equatorColor", "FFFF0000");
        p.setProperty(".datelineColor", "FF000099");
        p.setProperty(".specialLineColor", "FF000000");
        p.setProperty(".textColor", "FF000000");
        layer.setProperties("", p);
        this.layerHandler.addLayer((Layer)layer);
    }

    protected void addLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        Layer layer = null;
        if (mapFile.endsWith(".shp")) {
            layer = this.getShapeLayer(layerId, mapFile, lineColor, fillColor);
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find layer for " + mapFile + " (unknown type)"));
        }
        if (layer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add layer " + layer));
            }
            this.layerHandler.addLayer(layer);
        }
    }

    protected Layer getShapeLayer(String layerId, String mapFile, String lineColor, String fillColor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get ShapeLayer with filename : " + mapFile));
        }
        ShapeLayer shapeLayer = new ShapeLayer();
        Properties p = new Properties();
        p.setProperty(layerId + "." + "shapeFile", mapFile);
        p.setProperty(layerId + "." + "lineColor", lineColor);
        p.setProperty(layerId + "." + "fillColor", fillColor);
        shapeLayer.setProperties(layerId, p);
        shapeLayer.setName(layerId);
        return shapeLayer;
    }
}

