/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.ControlErrorGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class GlobalControlErrorModel
extends AbstractTreeTableModel {
    private static final long serialVersionUID = -32286733264427664L;
    protected List<ControlError> controlErrors;
    protected List<Object> controlErrorCategory;
    protected Map<Object, List<ControlErrorGroup>> controlCategoryChild;
    protected Map<ControlErrorGroup, List<ControlError>> controlErrorsChilds;
    protected Set<Object> checkedControlErrors;

    public GlobalControlErrorModel() {
        super((Object)1);
    }

    public void setControlErrors(List<ControlError> controlErrors) {
        this.controlErrors = controlErrors;
        this.getValidationErrorAsMaps(controlErrors);
        this.modelSupport.fireNewRoot();
    }

    public List<ControlError> getControlErrors() {
        return this.controlErrors;
    }

    protected void getValidationErrorAsMaps(List<ControlError> validationErrors) {
        this.controlCategoryChild = new HashMap<Object, List<ControlErrorGroup>>();
        this.controlErrorsChilds = new HashMap<ControlErrorGroup, List<ControlError>>();
        for (ControlError controlError : validationErrors) {
            ControlErrorGroup group;
            List<ControlError> childErrors;
            Object category = controlError.getCategory() == null ? I18n.n_((String)"coser.ui.control.error.allCategories", (Object[])new Object[0]) : controlError.getCategory();
            List<ControlErrorGroup> errorGroup = this.controlCategoryChild.get(category);
            if (errorGroup == null) {
                errorGroup = new ArrayList<ControlErrorGroup>();
                this.controlCategoryChild.put(category, errorGroup);
            }
            if ((childErrors = this.controlErrorsChilds.get(group = new ControlErrorGroup(controlError.getCategory(), controlError.getLevel(), controlError.getMessage()))) == null) {
                childErrors = new ArrayList<ControlError>();
                this.controlErrorsChilds.put(group, childErrors);
                errorGroup.add(group);
            }
            childErrors.add(controlError);
        }
        this.controlErrorCategory = new ArrayList<Object>(this.controlCategoryChild.keySet());
        Collections.sort(this.controlErrorCategory, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int result = -1;
                if (o1 instanceof String) {
                    if (o2 instanceof String) {
                        result = ((String)o1).compareTo((String)o2);
                    }
                } else if (o1 instanceof CoserConstants.Category && o2 instanceof CoserConstants.Category) {
                    result = ((CoserConstants.Category)o1).compareTo((Enum)((CoserConstants.Category)o2));
                }
                return result;
            }
        });
        for (List list : this.controlCategoryChild.values()) {
            Collections.sort(list);
        }
        this.checkedControlErrors = new HashSet<Object>();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        String result = null;
        switch (columnIndex) {
            case 0: {
                result = I18n._((String)"coser.ui.control.global.message", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = CoserConstants.ValidationLevel.class;
                break;
            }
            case 1: {
                result = Boolean.class;
            }
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        Object result = null;
        switch (column) {
            case 0: {
                result = node;
                break;
            }
            default: {
                result = this.checkedControlErrors.contains(node);
            }
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == this.getRoot()) {
            result = this.controlErrorCategory.get(index);
        } else if (parent instanceof String || parent instanceof CoserConstants.Category) {
            result = this.controlCategoryChild.get(parent).get(index);
        } else if (parent instanceof ControlErrorGroup) {
            List<ControlError> childError = this.controlErrorsChilds.get(parent);
            result = childError.get(index);
        }
        return result;
    }

    public int getChildCount(Object parent) {
        int result = 0;
        if (parent == this.getRoot()) {
            if (this.controlErrorCategory != null) {
                result = this.controlErrorCategory.size();
            }
        } else if (parent instanceof String || parent instanceof CoserConstants.Category) {
            result = this.controlCategoryChild.get(parent).size();
        } else if (parent instanceof ControlErrorGroup) {
            List<ControlError> childError = this.controlErrorsChilds.get(parent);
            result = childError.size();
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        if (parent == this.getRoot()) {
            result = this.controlErrorCategory.indexOf(child);
        } else if (parent instanceof String || parent instanceof CoserConstants.Category) {
            result = this.controlCategoryChild.get(parent).indexOf(child);
        } else if (parent instanceof ControlErrorGroup) {
            List<ControlError> childError = this.controlErrorsChilds.get(parent);
            result = childError.indexOf(child);
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        boolean result = false;
        if (column == 1) {
            result = true;
        }
        return result;
    }

    public void setValueAt(Object value, Object node, int column) {
        Boolean booleanValue = (Boolean)value;
        if (booleanValue.booleanValue()) {
            this.checkedControlErrors.add(node);
        } else {
            this.checkedControlErrors.remove(node);
        }
        if (node instanceof String || node instanceof CoserConstants.Category || node instanceof ControlErrorGroup) {
            int childCount = this.getChildCount(node);
            for (int i = 0; i < childCount; ++i) {
                Object child = this.getChild(node, i);
                this.setValueAt(value, child, column);
            }
        }
    }
}

