/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.selection.model;

import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.ui.selection.SelectionDetailsView;
import fr.ifremer.coser.ui.util.CoserListModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;

public class SpeciesTypesListModel
extends AbstractListModel
implements CoserListModel {
    private static final long serialVersionUID = 441910182067909029L;
    protected SelectionDetailsView view;
    protected List<String> types;
    protected Map<String, String> typesComments;

    public SpeciesTypesListModel(SelectionDetailsView view) {
        this.view = view;
    }

    protected List<String> getTypes() {
        if (this.types == null) {
            Project project = this.view.getContextValue(Project.class);
            ProjectService service = this.view.getContextValue(ProjectService.class);
            this.typesComments = service.getProjectSpeciesTypes(project);
            this.types = new ArrayList<String>(this.typesComments.keySet());
        }
        return this.types;
    }

    public String getComment(String species) {
        return this.typesComments.get(species);
    }

    @Override
    public int getSize() {
        return this.getTypes().size();
    }

    public Object getElementAt(int index) {
        return this.getTypes().get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.getTypes().indexOf(element);
    }
}

