/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.helper.JGitFlowSetupHelper;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.MavenSessionProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.atlassian.maven.plugins.jgitflow.provider.ReactorProjectsProvider;
import com.atlassian.maven.plugins.jgitflow.provider.VersionProvider;
import com.atlassian.maven.plugins.jgitflow.rewrite.ArtifactReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ParentReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeset;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectRewriter;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="build-number", aggregator=true)
public class BuildNumberMojo
extends AbstractJGitFlowMojo {
    @Parameter(property="buildNumber")
    private String buildNumber;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(defaultValue="-build", property="buildNumberVersionSuffix")
    private String buildNumberVersionSuffix = "-build";
    @Component
    protected JGitFlowProvider jGitFlowProvider;
    @Component
    protected ProjectHelper projectHelper;
    @Component
    protected ProjectRewriter projectRewriter;
    @Component
    protected VersionProvider versionProvider;
    @Component
    protected ContextProvider contextProvider;
    @Component
    protected MavenSessionProvider sessionProvider;
    @Component
    protected ReactorProjectsProvider projectsProvider;
    @Component
    protected JGitFlowSetupHelper setupHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<MavenProject> reactorProjects = this.getReactorProjects();
        try {
            this.runPreflight(reactorProjects);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error setting up build number mojo: " + e.getMessage(), e);
        }
        Map<String, String> originalVersions = this.versionProvider.getOriginalVersions(ProjectCacheKey.BUILD_NUMBER, reactorProjects);
        Map featureSuffixedVersions = Maps.transformValues(originalVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + BuildNumberMojo.this.buildNumberVersionSuffix + BuildNumberMojo.this.buildNumber;
                }
                return input;
            }
        });
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, featureSuffixedVersions, false)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(featureSuffixedVersions, false)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, featureSuffixedVersions, this.updateDependencies));
            try {
                this.projectRewriter.applyChanges(project, changes);
            }
            catch (ProjectRewriteException e) {
                throw new MojoExecutionException("Error updating poms with build numbers versions", (Exception)e);
            }
        }
    }

    protected void setupProviders(MavenSession session, List<MavenProject> projects) {
        this.contextProvider.setContext(new ReleaseContext(this.getBasedir()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setDefaultOriginUrl(this.defaultOriginUrl).setEnableSshAgent(this.enableSshAgent).setUseReleaseProfile(false).setUsername(this.username).setPassword(this.password).setEol(this.eol).setAllowRemote(this.isRemoteAllowed()));
        this.sessionProvider.setSession(session);
        this.projectsProvider.setReactorProjects(projects);
    }

    public void runPreflight(List<MavenProject> reactorProjects) throws JGitFlowException, MavenJGitFlowException {
        this.setupProviders(this.session, reactorProjects);
        this.setupHelper.setupCredentialProviders();
        JGitFlow flow = this.jGitFlowProvider.gitFlow();
        this.setupHelper.runCommonSetup();
    }
}

