/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.AbstractBranchCreatingCommand;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.exception.TagExistsException;
import com.atlassian.jgitflow.core.extension.FeatureStartExtension;
import com.atlassian.jgitflow.core.extension.impl.EmptyFeatureStartExtension;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class FeatureStartCommand
extends AbstractBranchCreatingCommand<FeatureStartCommand, Ref> {
    private static final String SHORT_NAME = "feature-start";
    private FeatureStartExtension extension = new EmptyFeatureStartExtension();

    public FeatureStartCommand(String branchName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(branchName, git, gfConfig, reporter);
    }

    @Override
    public Ref call() throws NotInitializedException, JGitFlowGitAPIException, LocalBranchExistsException, BranchOutOfDateException, JGitFlowIOException, LocalBranchMissingException, RemoteBranchExistsException, JGitFlowExtensionException, TagExistsException {
        String prefixedBranchName = this.runBeforeAndGetPrefixedBranchName(this.extension.before(), JGitFlowConstants.PREFIXES.FEATURE);
        this.enforcer().requireGitFlowInitialized();
        this.enforcer().requireLocalBranchAbsent(prefixedBranchName);
        try {
            this.doFetchIfNeeded(this.extension);
            Ref newBranch = this.doCreateBranch(this.gfConfig.getDevelop(), prefixedBranchName, this.extension);
            this.doPushNewBranchIfNeeded(this.extension, prefixedBranchName);
            this.runExtensionCommands(this.extension.after());
            Ref ref = newBranch;
            return ref;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
        finally {
            this.reporter.endCommand();
            this.reporter.flush();
        }
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }

    public FeatureStartCommand setExtension(FeatureStartExtension extension) {
        this.extension = extension;
        return this;
    }
}

