/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.ssl.CertificateHostnameVerifier;
import edu.vt.middleware.ldap.ssl.TLSSocketFactory;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultHostnameVerifier
implements HostnameVerifier,
CertificateHostnameVerifier {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public boolean verify(String hostname, SSLSession session) {
        boolean b;
        block3: {
            b = false;
            try {
                String name = null;
                if (hostname != null) {
                    name = hostname.startsWith("[") && hostname.endsWith("]") ? hostname.substring(1, hostname.length() - 1).trim() : hostname.trim();
                }
                b = this.verify(name, (X509Certificate)session.getPeerCertificates()[0]);
            }
            catch (SSLPeerUnverifiedException e) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn((Object)"Could not get certificate from the SSL session", (Throwable)e);
            }
        }
        return b;
    }

    public boolean verify(String hostname, X509Certificate cert) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Verify with the following parameters:");
            this.logger.debug((Object)("  hostname = " + hostname));
            this.logger.debug((Object)("  cert = " + cert.getSubjectX500Principal().toString()));
        }
        boolean b = false;
        b = LdapUtil.isIPAddress(hostname) ? this.verifyIP(hostname, cert) : this.verifyDNS(hostname, cert);
        return b;
    }

    protected boolean verifyIP(String ip, X509Certificate cert) {
        Object[] subjAltNames = this.getSubjectAltNames(cert, SubjectAltNameType.IP_ADDRESS);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("verifyIP using subjectAltNames = " + Arrays.toString(subjAltNames)));
        }
        for (Object name : subjAltNames) {
            if (!ip.equalsIgnoreCase((String)name)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("verifyIP found hostname match: " + (String)name));
            }
            return true;
        }
        return false;
    }

    protected boolean verifyDNS(String hostname, X509Certificate cert) {
        boolean verified = false;
        Object[] subjAltNames = this.getSubjectAltNames(cert, SubjectAltNameType.DNS_NAME);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("verifyDNS using subjectAltNames = " + Arrays.toString(subjAltNames)));
        }
        if (subjAltNames.length > 0) {
            for (Object name : subjAltNames) {
                if (!this.isMatch(hostname, (String)name)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("verifyDNS found hostname match: " + (String)name));
                }
                verified = true;
                break;
            }
        } else {
            Object[] cns = this.getCNs(cert);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("verifyDNS using CN = " + Arrays.toString(cns)));
            }
            if (cns.length > 0 && this.isMatch(hostname, cns[0])) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("verifyDNS found hostname match: " + (String)cns[0]));
                }
                verified = true;
            }
        }
        return verified;
    }

    private String[] getSubjectAltNames(X509Certificate cert, SubjectAltNameType type) {
        ArrayList<String> names;
        block4: {
            names = new ArrayList<String>();
            try {
                Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
                if (subjAltNames != null) {
                    for (List<?> generalName : subjAltNames) {
                        Integer nameType = (Integer)generalName.get(0);
                        if (nameType.intValue() != type.ordinal()) continue;
                        names.add((String)generalName.get(1));
                    }
                }
            }
            catch (CertificateParsingException e) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn((Object)"Error reading subject alt names from certificate", (Throwable)e);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getCNs(X509Certificate cert) {
        ArrayList<String> names = new ArrayList<String>();
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        StringTokenizer st = new StringTokenizer(subjectPrincipal, ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int x = tok.indexOf("CN=");
            if (x < 0) continue;
            names.add(tok.substring(x + "CN=".length()));
        }
        return names.toArray(new String[names.size()]);
    }

    private boolean isMatch(String hostname, String certName) {
        boolean isWildcard = certName.startsWith("*.") && certName.indexOf(46) < certName.lastIndexOf(46);
        boolean match = false;
        if (isWildcard) {
            String certNameDomain = certName.substring(certName.indexOf("."));
            int hostnameIdx = hostname.indexOf(".") != -1 ? hostname.indexOf(".") : hostname.length();
            String hostnameDomain = hostname.substring(hostnameIdx);
            match = certNameDomain.equalsIgnoreCase(hostnameDomain);
        } else {
            match = certName.equalsIgnoreCase(hostname);
        }
        return match;
    }

    public static class SSLSocketFactory
    extends TLSSocketFactory {
        public SSLSocketFactory() {
            this.setHostnameVerifier(new DefaultHostnameVerifier());
        }

        public static SocketFactory getDefault() {
            SSLSocketFactory sf;
            block2: {
                sf = new SSLSocketFactory();
                try {
                    sf.initialize();
                }
                catch (GeneralSecurityException e) {
                    Log logger = LogFactory.getLog(TLSSocketFactory.class);
                    if (!logger.isErrorEnabled()) break block2;
                    logger.error((Object)"Error initializing socket factory", (Throwable)e);
                }
            }
            return sf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubjectAltNameType {
        OTHER_NAME,
        RFC822_NAME,
        DNS_NAME,
        X400_ADDRESS,
        DIRECTORY_NAME,
        EDI_PARTY_NAME,
        UNIFORM_RESOURCE_IDENTIFIER,
        IP_ADDRESS,
        REGISTERED_ID;

    }
}

