/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.handler.CopySearchResultHandler;
import edu.vt.middleware.ldap.handler.ExtendedSearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveSearchResultHandler
extends CopySearchResultHandler
implements ExtendedSearchResultHandler {
    private Ldap ldap;
    private String searchAttribute;
    private String[] mergeAttributes;
    private String[] retAttrs;

    public RecursiveSearchResultHandler() {
    }

    public RecursiveSearchResultHandler(String searchAttr, String[] mergeAttrs) {
        this(null, searchAttr, mergeAttrs);
    }

    public RecursiveSearchResultHandler(Ldap l, String searchAttr, String[] mergeAttrs) {
        this.ldap = l;
        this.searchAttribute = searchAttr;
        this.mergeAttributes = mergeAttrs;
        this.initalizeReturnAttributes();
    }

    @Override
    public Ldap getSearchResultLdap() {
        return this.ldap;
    }

    @Override
    public void setSearchResultLdap(Ldap l) {
        this.ldap = l;
    }

    public String getSearchAttribute() {
        return this.searchAttribute;
    }

    public void setSearchAttribute(String s) {
        this.searchAttribute = s;
        this.initalizeReturnAttributes();
    }

    public String[] getMergeAttributes() {
        return this.mergeAttributes;
    }

    public void setMergeAttributes(String[] s) {
        this.mergeAttributes = s;
        this.initalizeReturnAttributes();
    }

    protected void initalizeReturnAttributes() {
        if (this.mergeAttributes != null && this.searchAttribute != null) {
            this.retAttrs = new String[this.mergeAttributes.length + 1];
            System.arraycopy(this.mergeAttributes, 0, this.retAttrs, 0, this.mergeAttributes.length);
            this.retAttrs[this.retAttrs.length - 1] = this.searchAttribute;
        }
    }

    @Override
    public List<SearchResult> process(SearchCriteria sc, NamingEnumeration<? extends SearchResult> en, Class<?>[] ignore) throws NamingException {
        return this.processInternal(super.process(sc, en, ignore));
    }

    @Override
    public List<SearchResult> process(SearchCriteria sc, List<? extends SearchResult> l) throws NamingException {
        return this.processInternal(super.process(sc, l));
    }

    private List<SearchResult> processInternal(List<SearchResult> results) throws NamingException {
        for (SearchResult sr : results) {
            ArrayList<String> searchedDns = new ArrayList<String>();
            if (sr.getAttributes().get(this.searchAttribute) != null) {
                searchedDns.add(sr.getName());
                this.readSearchAttribute(sr.getAttributes(), searchedDns);
                continue;
            }
            this.recursiveSearch(sr.getName(), sr.getAttributes(), searchedDns);
        }
        return results;
    }

    private void readSearchAttribute(Attributes attrs, List<String> searchedDns) throws NamingException {
        Attribute attr;
        if (attrs != null && (attr = attrs.get(this.searchAttribute)) != null) {
            NamingEnumeration<?> en = attr.getAll();
            while (en.hasMore()) {
                Object rawValue = en.next();
                if (!(rawValue instanceof String)) continue;
                this.recursiveSearch((String)rawValue, attrs, searchedDns);
            }
        }
    }

    private void recursiveSearch(String dn, Attributes attrs, List<String> searchedDns) throws NamingException {
        if (!searchedDns.contains(dn)) {
            Attributes newAttrs;
            block7: {
                newAttrs = null;
                try {
                    newAttrs = this.ldap.getAttributes(dn, this.retAttrs);
                }
                catch (NamingException e) {
                    if (!this.logger.isWarnEnabled()) break block7;
                    this.logger.warn((Object)("Error retreiving attribute(s): " + Arrays.toString(this.retAttrs)), (Throwable)e);
                }
            }
            searchedDns.add(dn);
            if (newAttrs != null) {
                this.readSearchAttribute(newAttrs, searchedDns);
                for (String s : this.mergeAttributes) {
                    Attribute newAttr = newAttrs.get(s);
                    if (newAttr == null) continue;
                    Attribute oldAttr = attrs.get(s);
                    if (oldAttr == null) {
                        attrs.put(newAttr);
                        continue;
                    }
                    NamingEnumeration<?> newValues = newAttr.getAll();
                    while (newValues.hasMore()) {
                        oldAttr.add(newValues.next());
                    }
                }
            }
        }
    }
}

