/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml;

import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.dsml.AbstractDsml;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dsmlv2
extends AbstractDsml {
    private static final long serialVersionUID = -1503268164295032020L;

    @Override
    public Document createDsml(Iterator<SearchResult> results) {
        Document dsml;
        block2: {
            dsml = null;
            try {
                LdapResult lr = this.beanFactory.newLdapResult();
                lr.addEntries(results);
                dsml = this.createDsml(lr);
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)"Error creating Element from SearchResult", (Throwable)e);
            }
        }
        return dsml;
    }

    @Override
    public Document createDsml(LdapResult result) {
        Namespace ns = new Namespace("", "urn:oasis:names:tc:DSML:2:0:core");
        Document doc = DocumentHelper.createDocument();
        Element dsmlElement = doc.addElement(new QName("batchResponse", ns));
        Element entriesElement = dsmlElement.addElement(new QName("searchResponse", ns));
        if (result != null) {
            for (LdapEntry le : result.getEntries()) {
                Element entryElement = this.createDsmlEntry(new QName("searchResultEntry", ns), le, ns);
                entriesElement.add(entryElement);
            }
        }
        Element doneElement = entriesElement.addElement(new QName("searchResultDone", ns));
        Element codeElement = doneElement.addElement(new QName("resultCode", ns));
        codeElement.addAttribute("code", "0");
        return doc;
    }

    public Iterator<SearchResult> createSearchResults(Document doc) {
        return this.createLdapResult(doc).toSearchResults().iterator();
    }

    @Override
    public LdapResult createLdapResult(Document doc) {
        LdapResult result = this.beanFactory.newLdapResult();
        if (doc != null && doc.hasContent()) {
            Iterator entryIterator = doc.selectNodes("/*[name()='batchResponse']/*[name()='searchResponse']/*[name()='searchResultEntry']").iterator();
            while (entryIterator.hasNext()) {
                LdapEntry le = this.createLdapEntry((Element)entryIterator.next());
                if (le == null) continue;
                result.addEntry(le);
            }
        }
        return result;
    }
}

