/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth;

import edu.vt.middleware.ldap.AbstractCli;
import edu.vt.middleware.ldap.auth.Authenticator;
import edu.vt.middleware.ldap.auth.AuthenticatorConfig;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.dsml.Dsmlv1;
import edu.vt.middleware.ldap.dsml.Dsmlv2;
import edu.vt.middleware.ldap.ldif.Ldif;
import edu.vt.middleware.ldap.props.LdapConfigPropertyInvoker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.naming.directory.Attributes;
import org.apache.commons.cli.CommandLine;

public class AuthenticatorCli
extends AbstractCli {
    private static final String COMMAND_NAME = "ldapauth";

    public static void main(String[] args) {
        new AuthenticatorCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions(new LdapConfigPropertyInvoker(AuthenticatorConfig.class, "edu.vt.middleware.ldap.auth."));
    }

    protected AuthenticatorConfig initAuthenticatorConfig(CommandLine line) throws Exception {
        String pass;
        AuthenticatorConfig config = new AuthenticatorConfig();
        this.initLdapProperties(config, line);
        if (line.hasOption("trace")) {
            config.setTracePackets(System.out);
        }
        if (config.getBindDn() != null && config.getBindCredential() == null) {
            System.out.print("Enter password for service user " + config.getBindDn() + ": ");
            pass = new BufferedReader(new InputStreamReader(System.in)).readLine();
            config.setBindCredential(pass);
        }
        if (config.getUser() == null) {
            System.out.print("Enter user name: ");
            String user = new BufferedReader(new InputStreamReader(System.in)).readLine();
            config.setUser(user);
        }
        if (config.getCredential() == null) {
            System.out.print("Enter password for user " + config.getUser() + ": ");
            pass = new BufferedReader(new InputStreamReader(System.in)).readLine();
            config.setCredential(pass);
        }
        return config;
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption("dsmlv1")) {
            this.outputDsmlv1 = true;
        } else if (line.hasOption("dsmlv2")) {
            this.outputDsmlv2 = true;
        }
        if (line.hasOption("help")) {
            this.printHelp();
        } else {
            this.authenticate(this.initAuthenticatorConfig(line), line.getArgs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticate(AuthenticatorConfig config, String[] attrs) throws Exception {
        Authenticator auth = new Authenticator();
        auth.setAuthenticatorConfig(config);
        Attributes results = null;
        try {
            results = attrs == null || attrs.length == 0 ? auth.authenticate(null) : auth.authenticate(attrs);
            if (results != null && results.size() > 0) {
                LdapEntry entry = LdapBeanProvider.getLdapBeanFactory().newLdapEntry();
                LdapResult result = LdapBeanProvider.getLdapBeanFactory().newLdapResult();
                result.addEntry(entry);
                entry.setDn(auth.getDn(config.getUser()));
                LdapAttributes la = LdapBeanProvider.getLdapBeanFactory().newLdapAttributes();
                la.addAttributes(results);
                entry.setLdapAttributes(la);
                if (this.outputDsmlv1) {
                    new Dsmlv1().outputDsml(result.toSearchResults().iterator(), (Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
                } else if (this.outputDsmlv2) {
                    new Dsmlv2().outputDsml(result.toSearchResults().iterator(), (Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
                } else {
                    new Ldif().outputLdif(result.toSearchResults().iterator(), (Writer)new BufferedWriter(new OutputStreamWriter(System.out)));
                }
            }
        }
        finally {
            if (auth != null) {
                auth.close();
            }
        }
    }

    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

