/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.CredentialConfig;
import edu.vt.middleware.ldap.ssl.PrivateKeyCredentialReader;
import edu.vt.middleware.ldap.ssl.SSLContextInitializer;
import edu.vt.middleware.ldap.ssl.X509CertificateCredentialReader;
import edu.vt.middleware.ldap.ssl.X509CertificatesCredentialReader;
import edu.vt.middleware.ldap.ssl.X509SSLContextInitializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class X509CredentialConfig
implements CredentialConfig {
    protected X509CertificatesCredentialReader certsReader = new X509CertificatesCredentialReader();
    protected X509CertificateCredentialReader certReader = new X509CertificateCredentialReader();
    protected PrivateKeyCredentialReader keyReader = new PrivateKeyCredentialReader();
    private String trustCertificates;
    private String authenticationCertificate;
    private String authenticationKey;

    public String getTrustCertificates() {
        return this.trustCertificates;
    }

    public void setTrustCertificates(String s) {
        this.trustCertificates = s;
    }

    public String getAuthenticationCertificate() {
        return this.authenticationCertificate;
    }

    public void setAuthenticationCertificate(String s) {
        this.authenticationCertificate = s;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(String s) {
        this.authenticationKey = s;
    }

    public SSLContextInitializer createSSLContextInitializer() throws GeneralSecurityException {
        X509SSLContextInitializer sslInit = new X509SSLContextInitializer();
        try {
            if (this.trustCertificates != null) {
                sslInit.setTrustCertificates((X509Certificate[])this.certsReader.read(this.trustCertificates, new String[0]));
            }
            if (this.authenticationCertificate != null) {
                sslInit.setAuthenticationCertificate((X509Certificate)this.certReader.read(this.authenticationCertificate, new String[0]));
            }
            if (this.authenticationKey != null) {
                sslInit.setAuthenticationKey((PrivateKey)this.keyReader.read(this.authenticationKey, new String[0]));
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return sslInit;
    }
}

