/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets;

import edu.vt.middleware.ldap.auth.Authenticator;
import edu.vt.middleware.ldap.servlets.CommonServlet;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class LoginServlet
extends CommonServlet {
    private static final long serialVersionUID = -3482852409544351134L;
    private String loginUrl;
    private String errorMsg;
    private Authenticator auth;

    public void init(ServletConfig config) throws ServletException {
        String propertiesFile;
        super.init(config);
        this.loginUrl = this.getInitParameter("edu.vt.middleware.ldap.servlets.loginUrl");
        if (this.loginUrl == null) {
            this.loginUrl = "/";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.loginUrl = " + this.loginUrl));
        }
        this.errorMsg = this.getInitParameter("edu.vt.middleware.ldap.servlets.errorMsg");
        if (this.errorMsg == null) {
            this.errorMsg = "Could not authenticate or authorize user";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.errorMsg = " + this.errorMsg));
        }
        if ((propertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.propertiesFile")) == null) {
            propertiesFile = "/ldap.properties";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.propertiesFile = " + propertiesFile));
        }
        this.auth = new Authenticator();
        this.auth.loadFromProperties(LoginServlet.class.getResourceAsStream(propertiesFile));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuffer error;
        String url;
        String user;
        block23: {
            boolean validCredentials;
            block22: {
                validCredentials = false;
                user = request.getParameter("user");
                if (user != null) {
                    user = user.trim().toLowerCase();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received user param = " + user));
                }
                String credential = request.getParameter("credential");
                url = request.getParameter("url");
                if (url == null) {
                    url = "";
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received url param = " + url));
                }
                error = new StringBuffer(this.errorMsg);
                try {
                    if (this.auth.authenticate(user, credential)) {
                        validCredentials = true;
                    }
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)("Error authenticating user " + user), (Throwable)e);
                    }
                    if (e.getCause() != null && e.getCause().getMessage() != null && !"null".equals(e.getCause().getMessage())) {
                        error.append(": ").append(e.getCause().getMessage());
                    }
                    if (e.getMessage() == null || "null".equals(e.getMessage())) break block22;
                    error.append(": ").append(e.getMessage());
                }
            }
            if (validCredentials) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Authentication succeeded for user " + user));
                }
                try {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    session = request.getSession(true);
                    this.sessionManager.login(session, user);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Initialized session for user " + user));
                    }
                    response.sendRedirect(url);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Redirected user to " + url));
                    }
                    return;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)("Error authorizing user " + user), (Throwable)e);
                    }
                    if (e.getCause() != null && e.getCause().getMessage() != null && !"null".equals(e.getCause().getMessage())) {
                        error.append(": ").append(e.getCause().getMessage());
                    }
                    if (e.getMessage() == null || "null".equals(e.getMessage())) break block23;
                    error.append(": ").append(e.getMessage());
                }
            }
        }
        StringBuffer errorUrl = new StringBuffer(this.loginUrl);
        if (error != null) {
            errorUrl.append("?error=").append(URLEncoder.encode(error.toString(), "UTF-8"));
        }
        if (user != null) {
            errorUrl.append("&user=").append(URLEncoder.encode(user, "UTF-8"));
        }
        if (url != null) {
            errorUrl.append("&url=").append(URLEncoder.encode(url, "UTF-8"));
        }
        response.sendRedirect(errorUrl.toString());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirected user to " + errorUrl.toString()));
        }
    }

    public void destroy() {
        super.destroy();
    }
}

