/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import edu.vt.middleware.ldap.auth.Authenticator;
import edu.vt.middleware.ldap.jaas.AbstractLoginModule;
import edu.vt.middleware.ldap.jaas.LdapCredential;
import edu.vt.middleware.ldap.jaas.LdapDnPrincipal;
import edu.vt.middleware.ldap.jaas.LdapPrincipal;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapLoginModule
extends AbstractLoginModule
implements LoginModule {
    private String[] userRoleAttribute = new String[0];
    private Authenticator auth;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.setLdapPrincipal = true;
        this.setLdapCredential = true;
        super.initialize(subject, callbackHandler, sharedState, options);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (!key.equalsIgnoreCase("userRoleAttribute")) continue;
            if ("*".equals(value)) {
                this.userRoleAttribute = null;
                continue;
            }
            this.userRoleAttribute = value.split(",");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("userRoleAttribute = " + Arrays.toString(this.userRoleAttribute)));
        }
        this.auth = LdapLoginModule.createAuthenticator(options);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created authenticator: " + this.auth.getAuthenticatorConfig()));
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String loginDn;
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            this.getCredentials(nameCb, passCb, false);
            AuthenticationException authEx = null;
            Attributes attrs = null;
            try {
                attrs = this.auth.authenticate(nameCb.getName(), (Object)passCb.getPassword(), this.userRoleAttribute);
                this.roles.addAll(this.attributesToRoles(attrs));
                if (this.defaultRole != null && !this.defaultRole.isEmpty()) {
                    this.roles.addAll(this.defaultRole);
                }
                this.loginSuccess = true;
            }
            catch (AuthenticationException e) {
                if (this.tryFirstPass) {
                    this.getCredentials(nameCb, passCb, true);
                    try {
                        attrs = this.auth.authenticate(nameCb.getName(), (Object)passCb.getPassword(), this.userRoleAttribute);
                        this.roles.addAll(this.attributesToRoles(attrs));
                        if (this.defaultRole != null && !this.defaultRole.isEmpty()) {
                            this.roles.addAll(this.defaultRole);
                        }
                        this.loginSuccess = true;
                    }
                    catch (AuthenticationException e2) {
                        authEx = e;
                        this.loginSuccess = false;
                    }
                }
                authEx = e;
                this.loginSuccess = false;
            }
            if (!this.loginSuccess) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Authentication failed", (Throwable)authEx);
                }
                throw new LoginException(authEx != null ? authEx.getMessage() : "Authentication failed");
            }
            if (this.setLdapPrincipal) {
                LdapPrincipal lp = new LdapPrincipal(nameCb.getName());
                if (attrs != null) {
                    lp.getLdapAttributes().addAttributes(attrs);
                }
                this.principals.add(lp);
            }
            if ((loginDn = this.auth.getDn(nameCb.getName())) != null && this.setLdapDnPrincipal) {
                LdapDnPrincipal lp = new LdapDnPrincipal(loginDn);
                if (attrs != null) {
                    lp.getLdapAttributes().addAttributes(attrs);
                }
                this.principals.add(lp);
            }
            if (this.setLdapCredential) {
                this.credentials.add(new LdapCredential(passCb.getPassword()));
            }
            this.storeCredentials(nameCb, passCb, loginDn);
        }
        catch (NamingException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error occured attempting authentication", (Throwable)e);
            }
            this.loginSuccess = false;
            throw new LoginException(e != null ? e.getMessage() : "Authentication Error");
        }
        finally {
            this.auth.close();
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String name = "vt-ldap";
        if (args.length > 0) {
            name = args[0];
        }
        LoginContext lc = new LoginContext(name, new TextCallbackHandler());
        lc.login();
        System.out.println("Authentication/Authorization succeeded");
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        for (Principal p : principals) {
            System.out.println("  " + p);
        }
        lc.logout();
    }
}

