/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;

/**
 * A shading {@link IPaint} implementation.
 */
public class ShadingPaint extends AbstractPaint {
	private float alphaValue;

	private PDShading shading;

	public ShadingPaint(PDShading shading) {
		super();
		this.shading = shading;
		this.alphaValue = 1.0f;
	}

	public IPaint copy() {
		ShadingPaint copy;

		copy = new ShadingPaint(shading);
		copy.alphaValue = alphaValue;
		copy.shading = shading;

		return copy;
	}

	public float getAlphaValue() {
		return alphaValue;
	}

	public PDShading getPdShading() {
		return shading;
	}

	public void setAlphaValue(float value) {
		alphaValue = value;
	}

	public void setBackgroundPaintFromGraphicsContext(
			IGraphicsContext graphicsContext) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get()
				.lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
		adapter.setBackgroundShadingPaint(graphicsContext, this);
	}

	public void setForegroundPaintFromGraphicsContext(
			IGraphicsContext graphicsContext) {
		IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get()
				.lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
		adapter.setForegroundShadingPaint(graphicsContext, this);
	}

}
