/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSDeviceGray extends AwtCSDevice {
	public AwtCSDeviceGray(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return ColorSpace.getInstance(ColorSpace.CS_GRAY);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.intarsys.pdf.pd.PDCSDevice#toColorModel(de.intarsys.pdf.pd.PDImage)
	 */
	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		int bits = pdImage.getBitsPerComponent();
		if (bits < 8) {
			byte[] values = new byte[(int) Math.pow(2, bits)];
			for (int index = 0; index < values.length; index++) {
				int value;

				value = (int) (index * (float) 255 / (values.length - 1));
				values[index] = (byte) (value & 0xFF);
			}
			ColorModel colormodel = new IndexColorModel(bits, values.length,
					values, values, values);
			return colormodel;
		}
		// reuse instance
		return CwtAwtImageTools.getGrayColorModel();
	}

	@Override
	public int getNumComponents() {
		return 1;
	}

	@Override
	public float[] getRGB(float[] values) {
		return new float[] { values[0], values[0], values[0] };
	}

	protected PDCSDeviceGray myPDColorSpace() {
		return (PDCSDeviceGray) getPDColorSpace();
	}
}
