/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

import de.intarsys.pdf.pd.PDCSCalGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSCalGray extends AwtCSCIEBased {

	public AwtCSCalGray(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return getColorSpace(myPDColorSpace().getAlternate()).getColorSpace();
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		return getColorSpace(myPDColorSpace().getAlternate()).getColorModel(
				pdImage);
	}

	protected PDCSCalGray myPDColorSpace() {
		return (PDCSCalGray) getPDColorSpace();
	}

}
