/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class COSName
extends COSPrimitiveObject {
    private String string;
    private final byte[] bytes;
    private int hash;

    public static COSName constant(String string) {
        return (COSName)COSName.create(string).beConstant();
    }

    public static COSName constantUTF8(String string) {
        return (COSName)COSName.createUTF8(string).beConstant();
    }

    public static COSName create(byte[] byArray) {
        return new COSName(byArray, true);
    }

    public static COSName create(String string) {
        return new COSName(string.getBytes(), true);
    }

    public static COSName createUTF8(String string) {
        try {
            return new COSName(string.getBytes("UTF-8"), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new COSName(string.getBytes(), true);
        }
    }

    protected COSName(byte[] byArray) {
        this.bytes = byArray;
    }

    protected COSName(byte[] byArray, boolean bl) {
        this.bytes = byArray;
        this.computeHash();
    }

    @Override
    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromName(this);
    }

    @Override
    public COSName asName() {
        return this;
    }

    @Override
    protected String basicToString() {
        return "/" + this.stringValue();
    }

    public byte[] byteValue() {
        return this.bytes;
    }

    private void computeHash() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bytes.length) {
            n = 31 * n + this.bytes[n2];
            ++n2;
        }
        this.hash = n;
    }

    @Override
    protected COSObject copyBasic() {
        COSName cOSName = new COSName(this.bytes);
        cOSName.string = this.string;
        cOSName.hash = this.hash;
        return cOSName;
    }

    protected String decode() {
        boolean bl = false;
        int n = 0;
        while (n < this.bytes.length) {
            int n2;
            if (this.bytes[n] < 0 && ((n2 = this.bytes[n] & 0xF8) == 192 || n2 == 224 || n2 == 240)) {
                if (n + 1 == this.bytes.length || (this.bytes[++n] & 0xC0) != 128) break;
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            try {
                return new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.bytes);
            }
        }
        return new String(this.bytes);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof COSName)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((COSName)object).byteValue());
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        COSName cOSName = (COSName)object;
        this.string = cOSName.string;
        this.hash = cOSName.hash;
    }

    public Object saveState() {
        COSName cOSName = new COSName(this.bytes);
        cOSName.string = this.string;
        cOSName.hash = this.hash;
        cOSName.container = this.container.saveStateContainer();
        return cOSName;
    }

    @Override
    public String stringValue() {
        if (this.string == null) {
            this.string = this.decode();
        }
        return this.string;
    }
}

