/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.PNGPrediction;

public class PNGSubPrediction
extends PNGPrediction {
    public PNGSubPrediction(COSDictionary options) {
        super(options);
    }

    protected void decodeRow(byte[] source, int sourceOffset, byte[] result, int resultOffset) {
        int bytesPerSample = (this.getBitsPerComponent() * this.getColors() + 7) / 8;
        byte[] sample = new byte[bytesPerSample];
        int sourceIndex = sourceOffset + 1;
        int resultIndex = resultOffset;
        System.arraycopy(source, sourceIndex, result, resultIndex, bytesPerSample);
        System.arraycopy(result, resultIndex, sample, 0, bytesPerSample);
        sourceIndex += bytesPerSample;
        resultIndex += bytesPerSample;
        while (resultIndex - resultOffset + bytesPerSample <= this.getResultRowSize()) {
            int index = 0;
            while (index < bytesPerSample) {
                result[resultIndex + index] = (byte)(sample[index] + source[sourceIndex + index] & 0xFF);
                ++index;
            }
            System.arraycopy(result, resultIndex, sample, 0, bytesPerSample);
            sourceIndex += bytesPerSample;
            resultIndex += bytesPerSample;
        }
    }
}

