/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.PNGPrediction;

public class PNGAveragePrediction
extends PNGPrediction {
    public PNGAveragePrediction(COSDictionary options) {
        super(options);
    }

    protected void decodeRow(byte[] source, int sourceOffset, byte[] result, int resultOffset) {
        int above;
        int left;
        int raw;
        int colors = this.getColors();
        if (this.getBitsPerComponent() != 8) {
            return;
        }
        if (++sourceOffset == 1) {
            int c = 0;
            while (c < colors) {
                result[resultOffset + c] = source[sourceOffset + c];
                ++c;
            }
            int x = 1;
            while (x < this.getResultRowSize()) {
                int raw2 = source[sourceOffset + x] & 0xFF;
                int left2 = result[resultOffset + x - colors] & 0xFF;
                int above2 = 0;
                result[resultOffset + x] = (byte)(raw2 + (left2 + above2) >> 1);
                ++x;
            }
            return;
        }
        int c = 0;
        while (c < colors) {
            raw = source[sourceOffset + c] & 0xFF;
            left = 0;
            above = result[resultOffset + c - this.getResultRowSize()] & 0xFF;
            result[resultOffset + c] = (byte)(raw + (left + above) >> 1);
            ++c;
        }
        int x = 1;
        while (x < this.getResultRowSize()) {
            raw = source[sourceOffset + x] & 0xFF;
            left = result[resultOffset + x - colors] & 0xFF;
            above = result[resultOffset + x - this.getResultRowSize()] & 0xFF;
            result[resultOffset + x] = (byte)(raw + (left + above) >> 1);
            ++x;
        }
    }
}

