/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.cos.ICOSProxyVisitor;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.collection.EmptyIterator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class COSObjectProxy
extends COSCompositeObject
implements Cloneable {
    private long position = -1L;
    private int length;
    private COSObject object;

    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        if (this.object != null) {
            return this.object.accept(visitor);
        }
        if (visitor instanceof ICOSProxyVisitor) {
            return ((ICOSProxyVisitor)((Object)visitor)).visitFromProxy(this);
        }
        return null;
    }

    public Iterator basicIterator() {
        if (this.object == null) {
            return EmptyIterator.UNIQUE;
        }
        return this.object.basicIterator();
    }

    protected String basicToString() {
        if (this.object == null) {
            return "COSObjectProxy: empty";
        }
        return this.object.stringValue();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected COSObject copyBasic() {
        COSObjectProxy proxy = (COSObjectProxy)this.clone();
        proxy.reserveData(this.getLength());
        return proxy;
    }

    public COSObject copyDeep(Map copied) {
        if (this.object != null) {
            return this.object.copyDeep(copied);
        }
        return super.copyDeep(copied);
    }

    public COSObject copyShallow() {
        if (this.object != null) {
            return this.object.copyShallow();
        }
        return super.copyShallow();
    }

    public COSObject cosGetObject() {
        return this.object == null ? COSNull.NULL : this.object;
    }

    protected abstract COSObject createCOSObject(IRandomAccess var1) throws IOException;

    public COSObject dereference() {
        return this.object == null ? this : this.object;
    }

    public void ended(COSWriter writer) throws IOException {
        if (this.object != null) {
            return;
        }
        IOException createObjException = null;
        IRandomAccess data = writer.getRandomAccess();
        data.mark();
        try {
            try {
                this.object = this.createCOSObject(data);
            }
            catch (IOException e) {
                createObjException = e;
            }
            data.seek(this.getPosition());
            if (this.object != null) {
                writer.writeObject(this.object);
            } else {
                writer.writeObject(COSNull.create());
            }
            long endPosition = this.getPosition() + (long)this.getLength();
            if (data.getOffset() < endPosition) {
                long dif = endPosition - data.getOffset();
                byte[] padding = new byte[(int)dif];
                Arrays.fill(padding, (byte)32);
                writer.write(padding);
            } else if (data.getOffset() > endPosition) {
                throw new IOException("Destroyed document, wrote more bytes than reserved!");
            }
            if (createObjException != null) {
                throw createObjException;
            }
        }
        finally {
            data.reset();
        }
    }

    public int getLength() {
        return this.length;
    }

    public COSObject getObject() {
        return this.object;
    }

    public long getPosition() {
        return this.position;
    }

    public Iterator iterator() {
        if (this.object == null) {
            return EmptyIterator.UNIQUE;
        }
        return this.object.iterator();
    }

    public boolean mayBeSwapped() {
        return false;
    }

    public void reserveData(int pLength) {
        this.length = pLength;
    }

    public Object saveState() {
        return null;
    }

    protected void setObject(COSObject object) {
        this.object = object;
    }

    public void setPosition(long position) {
        this.position = position;
    }
}

