/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public final class GraphicsState
implements IAttributeSupport {
    private final AttributeMap attributes = new AttributeMap();
    public int capStyle;
    public Shape clip;
    public float[] dashPattern;
    public float dashPhase;
    public int joinStyle;
    public float lineWidth;
    public float miterLimit;
    public float nonStrokeAlphaValue;
    public PDColorSpace nonStrokeColorSpace;
    public float[] nonStrokeColorValues;
    public float strokeAlphaValue;
    public PDColorSpace strokeColorSpace;
    public PDExtGState extState;
    public float[] strokeColorValues;
    public TextState textState;
    public AffineTransform transform;

    public GraphicsState() {
        this.dashPattern = new float[0];
        this.dashPhase = 0.0f;
        this.capStyle = 0;
        this.joinStyle = 0;
        this.lineWidth = 1.0f;
        this.miterLimit = 10.0f;
        this.nonStrokeAlphaValue = 1.0f;
        this.strokeAlphaValue = 1.0f;
        this.textState = new TextState();
        this.extState = null;
        this.transform = new AffineTransform();
    }

    protected GraphicsState(GraphicsState originalState) {
        this.capStyle = originalState.capStyle;
        this.dashPattern = originalState.dashPattern;
        this.dashPhase = originalState.dashPhase;
        if (originalState.extState != null) {
            this.extState = (PDExtGState)PDExtGState.META.createFromCos(originalState.extState.cosGetObject().copyShallow());
        }
        this.joinStyle = originalState.joinStyle;
        this.lineWidth = originalState.lineWidth;
        this.miterLimit = originalState.miterLimit;
        this.nonStrokeAlphaValue = originalState.nonStrokeAlphaValue;
        this.nonStrokeColorSpace = originalState.nonStrokeColorSpace;
        this.nonStrokeColorValues = originalState.nonStrokeColorValues;
        this.strokeAlphaValue = originalState.strokeAlphaValue;
        this.strokeColorSpace = originalState.strokeColorSpace;
        this.strokeColorValues = originalState.strokeColorValues;
        this.textState = originalState.textState.copy();
        this.transform = originalState.transform;
        this.clip = originalState.clip;
    }

    public GraphicsState copy() {
        return new GraphicsState(this);
    }

    public final Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }
}

