/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.IUnEscaper;
import de.intarsys.tools.stream.StreamTools;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class UnEscapeReader
extends FilterReader
implements IUnEscaper {
    public static final char DefaultEscape = '\\';
    private static final Map DefaultEscapeMap = new HashMap();
    private char escape = (char)92;
    private Map escapeMap = DefaultEscapeMap;
    private boolean mapped = false;
    private boolean open = true;
    private char unicodePrefix = (char)117;

    static {
        DefaultEscapeMap.put(new Character('\\'), new Character('\\'));
        DefaultEscapeMap.put(new Character('n'), new Character('\n'));
        DefaultEscapeMap.put(new Character('r'), new Character('\r'));
        DefaultEscapeMap.put(new Character('t'), new Character('\t'));
        DefaultEscapeMap.put(new Character('\n'), null);
        DefaultEscapeMap.put(new Character('\r'), null);
        DefaultEscapeMap.put(new Character('\t'), null);
        DefaultEscapeMap.put(new Character(' '), null);
    }

    public static String unescape(String in) throws IOException {
        UnEscapeReader reader = new UnEscapeReader(new StringReader(in));
        return StreamTools.toString(reader);
    }

    public UnEscapeReader(Reader in) {
        super(in);
    }

    public UnEscapeReader(Reader in, char escape, Map map) {
        super(in);
        this.escape = escape;
        this.escapeMap = map;
    }

    public UnEscapeReader(Reader in, Map map) {
        super(in);
        this.escapeMap = map;
    }

    public void addEscapedCharacter(char key, char value) {
        Map tempMap = this.getEscapeMap();
        tempMap.put(new Character(key), new Character(value));
        this.setEscapeMap(tempMap);
    }

    public void close() throws IOException {
        this.in.close();
        this.open = false;
    }

    public char getEscape() {
        return this.escape;
    }

    public Map getEscapeMap() {
        return new HashMap(this.escapeMap);
    }

    public char getUnicodePrefix() {
        return this.unicodePrefix;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public int read() throws IOException {
        this.mapped = false;
        int i = this.in.read();
        if (i == this.escape) {
            this.mapped = true;
            i = this.readEscaped();
        }
        return i;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int pos = off;
        int i = 0;
        while (pos < off + len && i != -1) {
            i = this.read();
            cbuf[pos] = (char)i;
            ++pos;
        }
        if (i == -1 && pos == off) {
            return -1;
        }
        return pos - off;
    }

    protected int readEscaped() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            return -1;
        }
        if ((char)i == '\r') {
            int next = this.read();
            if ((char)next == '\n' && !this.isMapped()) {
                return this.read();
            }
            return next;
        }
        if ((char)i == '\n') {
            return this.read();
        }
        if ((char)i == this.getUnicodePrefix()) {
            return this.readHex();
        }
        Character key = new Character((char)i);
        Character value = (Character)this.escapeMap.get(key);
        if (value == null) {
            if (this.escapeMap.containsKey(key)) {
                return this.read();
            }
            throw new IOException("unrecognized escape sequence: \"\\" + (char)i + "\"");
        }
        return value.charValue();
    }

    protected int readHex() throws IOException {
        StringBuilder buf = new StringBuilder();
        int ch = this.in.read();
        while (((char)ch >= '0' && (char)ch <= '9' || (char)ch >= 'A' && (char)ch <= 'F' || (char)ch >= 'a' && (char)ch <= 'f') && buf.length() < 4) {
            buf.append((char)ch);
            ch = this.in.read();
        }
        if (ch == -1) {
            return -1;
        }
        if (buf.length() < 4) {
            throw new IOException("illegal escape sequence: \"\\u" + buf.toString() + "\"");
        }
        String hexString = new String(buf);
        return Integer.parseInt(hexString, 16);
    }

    public void removeEscapedCharacter(char key) {
        Map tempMap = this.getEscapeMap();
        tempMap.remove(new Character(key));
        this.setEscapeMap(tempMap);
    }

    public void removeEscapedCharacters() {
        this.setEscapeMap(new HashMap());
    }

    public void setEscape(char newEscape) {
        if (newEscape == this.escape) {
            return;
        }
        Map tempMap = this.getEscapeMap();
        tempMap.remove(new Character(this.getEscape()));
        tempMap.put(new Character(newEscape), new Character(newEscape));
        this.setEscapeMap(tempMap);
        this.escape = newEscape;
    }

    protected void setEscapeMap(Map newEscapeMap) {
        this.escapeMap = newEscapeMap;
    }

    public void setUnicodePrefix(char newUniChar) {
        this.unicodePrefix = newUniChar;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IOException("parameter is negative");
        }
        long actual = 0L;
        int ch = 0;
        while (actual < n && ch != -1) {
            ch = this.read();
            ++actual;
        }
        return actual;
    }
}

